/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.util.client.render;

import dev.kir.sync.util.math.Voxel;
import dev.kir.sync.util.math.VoxelIterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.model.geom.ModelPart;

@Environment(value=EnvType.CLIENT)
public final class ModelUtil {
    public static ModelPart copy(ModelPart original) {
        ModelPart copy = new ModelPart(original.f_104212_, original.f_104213_);
        copy.m_104315_(original);
        return copy;
    }

    public static Stream<Voxel> asVoxels(ModelPart part) {
        return ModelUtil.asVoxels(0.0f, 0.0f, 0.0f, part);
    }

    public static Stream<Voxel> asVoxels(float x, float y, float z, ModelPart part) {
        float pivotX = x + part.f_104200_;
        float pivotY = y + part.f_104201_;
        float pivotZ = z + part.f_104202_;
        return Stream.concat(part.f_104212_.stream().flatMap(cuboid -> ModelUtil.asVoxels(pivotX, pivotY, pivotZ, cuboid)), part.f_104213_.values().stream().flatMap(p -> ModelUtil.asVoxels(pivotX, pivotY, pivotZ, p)));
    }

    public static Stream<Voxel> asVoxels(float x, float y, float z, ModelPart.Cube cuboid) {
        int sizeX = (int)(cuboid.f_104338_ - cuboid.f_104335_);
        int sizeY = (int)(cuboid.f_104339_ - cuboid.f_104336_);
        int sizeZ = (int)(cuboid.f_104340_ - cuboid.f_104337_);
        VoxelIterator iterator = new VoxelIterator(x, y, z, sizeX, sizeY, sizeZ);
        Spliterator<Voxel> spliterator = Spliterators.spliteratorUnknownSize(iterator, 0);
        return StreamSupport.stream(spliterator, false);
    }
}

