/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.util.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.Objects;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public final class RenderSystemUtil {
    public static final int MAX_LIGHT_LEVEL = 0xF000F0;
    private static final RenderBuffers BUFFER_BUILDER_STORAGE = new RenderBuffers();

    public static void drawTriangleStrip(Consumer<VertexConsumer> consumer) {
        RenderSystemUtil.drawTriangleStrip(consumer, DefaultVertexFormat.f_85815_);
    }

    public static void drawTriangleStrip(Consumer<VertexConsumer> consumer, VertexFormat format) {
        RenderSystemUtil.draw(consumer, VertexFormat.Mode.TRIANGLE_STRIP, format);
    }

    public static void drawAnnulusSector(PoseStack matrices, double cX, double cY, double majorR, double minorR, double from, double to, double step, float r, float g, float b, float a) {
        RenderSystemUtil.drawTriangleStrip(consumer -> RenderSystemUtil.drawAnnulusSector(matrices, consumer, cX, cY, majorR, minorR, from, to, step, r, g, b, a));
    }

    public static void drawAnnulusSector(PoseStack matrices, VertexConsumer consumer, double cX, double cY, double majorR, double minorR, double from, double to, double step, float r, float g, float b, float a) {
        to += step / 32.0;
        Matrix4f matrix = matrices.m_85850_().m_252922_();
        for (double i = from; i < to; i += step) {
            double sin = Math.sin(i);
            double cos = Math.cos(i);
            double x0 = majorR * cos + cX;
            double y0 = majorR * sin + cY;
            double x1 = minorR * cos + cX;
            double y1 = minorR * sin + cY;
            consumer.m_252986_(matrix, (float)x0, (float)y0, 0.0f).m_85950_(r, g, b, a).m_5752_();
            consumer.m_252986_(matrix, (float)x1, (float)y1, 0.0f).m_85950_(r, g, b, a).m_5752_();
        }
    }

    public static void drawRectangle(PoseStack matrices, float x, float y, float width, float height, float borderRadius, float scale, float rotation, float step, float r, float g, float b, float a) {
        RenderSystemUtil.drawTriangleStrip(consumer -> RenderSystemUtil.drawRectangle(matrices, consumer, x, y, width, height, borderRadius, scale, rotation, step, r, g, b, a));
    }

    public static void drawRectangle(PoseStack matrices, VertexConsumer consumer, float x, float y, float width, float height, float borderRadius, float scale, float rotation, float step, float r, float g, float b, float a) {
        matrices.m_85836_();
        matrices.m_252880_(x, y, 0.0f);
        matrices.m_252781_(Axis.f_252403_.m_252961_(rotation));
        matrices.m_85841_(scale, scale, 1.0f);
        matrices.m_252880_(-x, -y, 0.0f);
        Matrix4f matrix = matrices.m_85850_().m_252922_();
        RenderSystemUtil.drawQuadrant(matrix, consumer, x + width - borderRadius, y + height - borderRadius, borderRadius, 0, step, r, g, b, a);
        RenderSystemUtil.drawQuadrant(matrix, consumer, x + borderRadius, y + height - borderRadius, borderRadius, 1, step, r, g, b, a);
        RenderSystemUtil.drawQuadrant(matrix, consumer, x + borderRadius, y + borderRadius, borderRadius, 2, step, r, g, b, a);
        RenderSystemUtil.drawQuadrant(matrix, consumer, x + width - borderRadius, y + borderRadius, borderRadius, 3, step, r, g, b, a);
        consumer.m_252986_(matrix, x + width, y + height - borderRadius, 0.0f).m_85950_(r, g, b, a).m_5752_();
        consumer.m_252986_(matrix, x + borderRadius, y + borderRadius, 0.0f).m_85950_(r, g, b, a).m_5752_();
        consumer.m_252986_(matrix, x + borderRadius, y + height - borderRadius, 0.0f).m_85950_(r, g, b, a).m_5752_();
        matrices.m_85849_();
    }

    private static void drawQuadrant(Matrix4f matrix, VertexConsumer consumer, float cX, float cY, float radius, int index, float step, float r, float g, float b, float a) {
        float start = 1.5707964f * (float)index;
        float end = 1.5707964f * (float)(index + 1);
        for (float i = start; i < end; i += step) {
            float x = radius * (float)Math.cos(i) + cX;
            float y = radius * (float)Math.sin(i) + cY;
            consumer.m_252986_(matrix, x, y, 0.0f).m_85950_(r, g, b, a).m_5752_();
            consumer.m_252986_(matrix, cX, cY, 0.0f).m_85950_(r, g, b, a).m_5752_();
        }
        float x = radius * (float)Math.cos(end) + cX;
        float y = radius * (float)Math.sin(end) + cY;
        consumer.m_252986_(matrix, x, y, 0.0f).m_85950_(r, g, b, a).m_5752_();
        consumer.m_252986_(matrix, cX, cY, 0.0f).m_85950_(r, g, b, a).m_5752_();
    }

    public static void draw(Consumer<VertexConsumer> consumer, VertexFormat.Mode drawMode, VertexFormat format) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(drawMode, format);
        consumer.accept((VertexConsumer)bufferBuilder);
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderSystem.disableBlend();
    }

    public static Font getTextRenderer() {
        return Minecraft.m_91087_().f_91062_;
    }

    public static MultiBufferSource.BufferSource getEntityVertexConsumerProvider() {
        return BUFFER_BUILDER_STORAGE.m_110104_();
    }

    public static void drawCenteredText(GuiGraphics drawContext, Component text, float cX, float cY, int color) {
        RenderSystemUtil.drawCenteredText(drawContext, text, cX, cY, 1.0f, color);
    }

    public static void drawCenteredText(GuiGraphics drawContext, Component text, float cX, float cY, float scale, int color) {
        RenderSystemUtil.drawCenteredText(drawContext, text, cX, cY, scale, color, false);
    }

    public static void drawCenteredText(GuiGraphics drawContext, Component text, float cX, float cY, float scale, int color, boolean shadow) {
        RenderSystemUtil.drawCenteredText(drawContext, text, RenderSystemUtil.getTextRenderer(), cX, cY, scale, color, shadow);
    }

    public static void drawCenteredText(GuiGraphics drawContext, Component text, Font textRenderer, float cX, float cY, float scale, int color, boolean shadow) {
        MultiBufferSource.BufferSource immediate = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        RenderSystemUtil.drawCenteredText(drawContext, text, (MultiBufferSource)immediate, textRenderer, cX, cY, scale, color, shadow);
        immediate.m_109911_();
    }

    public static void drawCenteredText(GuiGraphics drawContext, Component text, MultiBufferSource vertexConsumers, Font textRenderer, float cX, float cY, float scale, int color, boolean shadow) {
        boolean backgroundColor = false;
        Objects.requireNonNull(textRenderer);
        float height = 9.0f * scale;
        float width = (float)textRenderer.m_92852_((FormattedText)text) * scale;
        PoseStack matrices = drawContext.m_280168_();
        matrices.m_85836_();
        matrices.m_252880_(cX -= width / 2.0f, cY -= height / 2.0f, 0.0f);
        matrices.m_85841_(scale, scale, 1.0f);
        matrices.m_252880_(-cX, -cY, 0.0f);
        drawContext.m_280614_(textRenderer, text, (int)cX, (int)cY, color, shadow);
        matrices.m_85849_();
    }
}

