/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.util.nbt;

import dev.kir.sync.util.nbt.NbtSerializerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public class NbtSerializerFactoryBuilder<TTarget> {
    private static final Map<Class<?>, BiFunction<CompoundTag, String, ?>> NBT_GETTERS = new HashMap();
    private static final Map<Class<?>, TriConsumer<CompoundTag, String, ?>> NBT_SETTERS;
    private final Collection<BiConsumer<TTarget, CompoundTag>> readers = new ArrayList<BiConsumer<TTarget, CompoundTag>>();
    private final Collection<BiConsumer<TTarget, CompoundTag>> writers = new ArrayList<BiConsumer<TTarget, CompoundTag>>();

    public <TProperty> NbtSerializerFactoryBuilder<TTarget> add(Class<TProperty> type, String key, Function<TTarget, TProperty> getter, BiConsumer<TTarget, TProperty> setter) {
        if (getter != null) {
            TriConsumer<CompoundTag, String, ?> nbtSetter = NBT_SETTERS.get(type);
            if (nbtSetter == null) {
                throw new UnsupportedOperationException();
            }
            this.writers.add((i, x) -> nbtSetter.accept((CompoundTag)x, key, getter.apply(i)));
        }
        if (setter != null) {
            BiFunction<CompoundTag, String, ?> nbtGetter = NBT_GETTERS.get(type);
            if (nbtGetter == null) {
                throw new UnsupportedOperationException();
            }
            this.readers.add((i, x) -> setter.accept(i, nbtGetter.apply((CompoundTag)x, key)));
        }
        return this;
    }

    public NbtSerializerFactory<TTarget> build() {
        return new NbtSerializerFactory(this.readers, this.writers);
    }

    private static BiFunction<CompoundTag, String, ?> getOrDefault(BiFunction<CompoundTag, String, ?> f) {
        return (nbt, key) -> nbt.m_128441_(key) ? f.apply((CompoundTag)nbt, (String)key) : null;
    }

    private static TriConsumer<CompoundTag, String, ?> setIfNotNull(TriConsumer<CompoundTag, String, Object> f) {
        return (nbt, key, x) -> {
            if (x != null) {
                f.accept((CompoundTag)nbt, (String)key, x);
            }
        };
    }

    static {
        NBT_GETTERS.put(Boolean.class, NbtSerializerFactoryBuilder.getOrDefault(CompoundTag::m_128471_));
        NBT_GETTERS.put(Byte.class, NbtSerializerFactoryBuilder.getOrDefault(CompoundTag::m_128445_));
        NBT_GETTERS.put(Double.class, NbtSerializerFactoryBuilder.getOrDefault(CompoundTag::m_128459_));
        NBT_GETTERS.put(Float.class, NbtSerializerFactoryBuilder.getOrDefault(CompoundTag::m_128457_));
        NBT_GETTERS.put(Integer.class, NbtSerializerFactoryBuilder.getOrDefault(CompoundTag::m_128451_));
        NBT_GETTERS.put(Long.class, NbtSerializerFactoryBuilder.getOrDefault(CompoundTag::m_128454_));
        NBT_GETTERS.put(Short.class, NbtSerializerFactoryBuilder.getOrDefault(CompoundTag::m_128448_));
        NBT_GETTERS.put(String.class, NbtSerializerFactoryBuilder.getOrDefault(CompoundTag::m_128461_));
        NBT_GETTERS.put(ResourceLocation.class, NbtSerializerFactoryBuilder.getOrDefault((x, key) -> new ResourceLocation(x.m_128461_(key))));
        NBT_GETTERS.put(UUID.class, NbtSerializerFactoryBuilder.getOrDefault(CompoundTag::m_128342_));
        NBT_GETTERS.put(CompoundTag.class, NbtSerializerFactoryBuilder.getOrDefault(CompoundTag::m_128469_));
        NBT_GETTERS.put(ListTag.class, NbtSerializerFactoryBuilder.getOrDefault(CompoundTag::m_128423_));
        NBT_GETTERS.put(BlockPos.class, NbtSerializerFactoryBuilder.getOrDefault((nbt, key) -> {
            CompoundTag compound = nbt.m_128469_(key);
            return new BlockPos(compound.m_128451_("x"), compound.m_128451_("y"), compound.m_128451_("z"));
        }));
        NBT_SETTERS = new HashMap();
        NBT_SETTERS.put(Boolean.class, NbtSerializerFactoryBuilder.setIfNotNull((nbt, key, x) -> nbt.m_128379_(key, ((Boolean)x).booleanValue())));
        NBT_SETTERS.put(Byte.class, NbtSerializerFactoryBuilder.setIfNotNull((nbt, key, x) -> nbt.m_128344_(key, ((Byte)x).byteValue())));
        NBT_SETTERS.put(Double.class, NbtSerializerFactoryBuilder.setIfNotNull((nbt, key, x) -> nbt.m_128347_(key, ((Double)x).doubleValue())));
        NBT_SETTERS.put(Float.class, NbtSerializerFactoryBuilder.setIfNotNull((nbt, key, x) -> nbt.m_128350_(key, ((Float)x).floatValue())));
        NBT_SETTERS.put(Integer.class, NbtSerializerFactoryBuilder.setIfNotNull((nbt, key, x) -> nbt.m_128405_(key, ((Integer)x).intValue())));
        NBT_SETTERS.put(Long.class, NbtSerializerFactoryBuilder.setIfNotNull((nbt, key, x) -> nbt.m_128356_(key, ((Long)x).longValue())));
        NBT_SETTERS.put(Short.class, NbtSerializerFactoryBuilder.setIfNotNull((nbt, key, x) -> nbt.m_128376_(key, ((Short)x).shortValue())));
        NBT_SETTERS.put(String.class, NbtSerializerFactoryBuilder.setIfNotNull((nbt, key, x) -> nbt.m_128359_(key, (String)x)));
        NBT_SETTERS.put(ResourceLocation.class, NbtSerializerFactoryBuilder.setIfNotNull((nbt, key, x) -> nbt.m_128359_(key, x.toString())));
        NBT_SETTERS.put(UUID.class, NbtSerializerFactoryBuilder.setIfNotNull((nbt, key, x) -> nbt.m_128362_(key, (UUID)x)));
        NBT_SETTERS.put(CompoundTag.class, NbtSerializerFactoryBuilder.setIfNotNull((nbt, key, x) -> nbt.m_128365_(key, (Tag)((CompoundTag)x))));
        NBT_SETTERS.put(ListTag.class, NbtSerializerFactoryBuilder.setIfNotNull((nbt, key, x) -> nbt.m_128365_(key, (Tag)((ListTag)x))));
        NBT_SETTERS.put(BlockPos.class, NbtSerializerFactoryBuilder.setIfNotNull((nbt, key, x) -> {
            BlockPos pos = (BlockPos)x;
            CompoundTag compound = new CompoundTag();
            compound.m_128405_("x", pos.m_123341_());
            compound.m_128405_("y", pos.m_123342_());
            compound.m_128405_("z", pos.m_123343_());
            nbt.m_128365_(key, (Tag)compound);
        }));
    }

    @FunctionalInterface
    private static interface TriConsumer<T, K, V> {
        public void accept(T var1, K var2, V var3);
    }
}

