/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.util.nbt;

import java.io.File;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class OfflinePlayerNbtManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String DATA_FILE_EXTENSION = ".dat";

    public static void editPlayerNbt(MinecraftServer server, UUID uuid, Consumer<CompoundTag> nbtEditor) {
        OfflinePlayerNbtManager.editPlayerNbt(server, uuid, (CompoundTag nbt) -> {
            nbtEditor.accept((CompoundTag)nbt);
            return nbt;
        });
    }

    public static void editPlayerNbt(MinecraftServer server, UUID uuid, Function<CompoundTag, CompoundTag> nbtEditor) {
        File nbtPath = server.m_129843_(LevelResource.f_78176_).resolve(uuid.toString() + DATA_FILE_EXTENSION).toFile();
        try {
            if (!nbtPath.isFile()) {
                return;
            }
            CompoundTag nbt = NbtIo.m_128937_((File)nbtPath);
            nbt = nbtEditor.apply(nbt);
            NbtIo.m_128944_((CompoundTag)nbt, (File)nbtPath);
        }
        catch (Throwable exception) {
            LOGGER.log(Level.ERROR, "Failed to edit player's nbt.", exception);
        }
    }
}

