/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slab;

import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.blockentity.doubled.FramedAdjustableDoubleBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.NullableDirection;

public abstract class FramedAdjustableDoubleBlock
extends AbstractFramedDoubleBlock {
    private final Function<BlockState, Direction> facingGetter;
    private final Function<BlockState, Tuple<BlockState, BlockState>> statePairBuilder;
    private final BlockEntityType.BlockEntitySupplier<FramedAdjustableDoubleBlockEntity> beSupplier;

    protected FramedAdjustableDoubleBlock(BlockType type, Function<BlockState, Direction> facingGetter, Function<BlockState, Tuple<BlockState, BlockState>> statePairBuilder, BlockEntityType.BlockEntitySupplier<FramedAdjustableDoubleBlockEntity> beSupplier) {
        super(type);
        this.facingGetter = facingGetter;
        this.statePairBuilder = statePairBuilder;
        this.beSupplier = beSupplier;
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        BlockEntity blockEntity;
        if (player.m_21205_().m_41720_() == FBContent.ITEM_FRAMED_HAMMER.get() && (blockEntity = level.m_7702_(pos)) instanceof FramedAdjustableDoubleBlockEntity) {
            FramedAdjustableDoubleBlockEntity be = (FramedAdjustableDoubleBlockEntity)blockEntity;
            return be.handleDeform(player);
        }
        return false;
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return this.beSupplier.m_155267_(pos, state);
    }

    @Override
    public Tuple<BlockState, BlockState> calculateBlockPair(BlockState state) {
        return this.statePairBuilder.apply(state);
    }

    public Direction getFacing(BlockState state) {
        return this.facingGetter.apply(state);
    }

    protected static Tuple<BlockState, BlockState> makeStandardStatePair(BlockState state) {
        Direction facing = ((FramedAdjustableDoubleBlock)state.m_60734_()).getFacing(state);
        BlockState defState = ((Block)FBContent.BLOCK_FRAMED_COLLAPSIBLE_BLOCK.get()).m_49966_();
        return new Tuple((Object)((BlockState)defState.m_61124_(PropertyHolder.NULLABLE_FACE, (Comparable)((Object)NullableDirection.fromDirection(facing)))), (Object)((BlockState)defState.m_61124_(PropertyHolder.NULLABLE_FACE, (Comparable)((Object)NullableDirection.fromDirection(facing.m_122424_())))));
    }

    protected static Tuple<BlockState, BlockState> makeCopycatStatePair(BlockState state) {
        Direction facing = ((FramedAdjustableDoubleBlock)state.m_60734_()).getFacing(state);
        BlockState defState = ((Block)FBContent.BLOCK_FRAMED_COLLAPSIBLE_COPYCAT_BLOCK.get()).m_49966_();
        int solidFirst = ~(1 << facing.ordinal()) & 0x3F;
        int solidSecond = ~(1 << facing.m_122424_().ordinal()) & 0x3F;
        return new Tuple((Object)((BlockState)defState.m_61124_((Property)PropertyHolder.SOLID_FACES, (Comparable)Integer.valueOf(solidFirst))), (Object)((BlockState)defState.m_61124_((Property)PropertyHolder.SOLID_FACES, (Comparable)Integer.valueOf(solidSecond))));
    }
}

