/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slopepanelcorner;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.block.slopepanelcorner.FramedCornerSlopePanelBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.item.VerticalAndWallBlockItem;

public class FramedExtendedCornerSlopePanelBlock
extends FramedBlock {
    public FramedExtendedCornerSlopePanelBlock(BlockType blockType) {
        super(blockType);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FramedProperties.FACING_HOR, FramedProperties.TOP, FramedProperties.Y_SLOPE, FramedProperties.SOLID, BlockStateProperties.f_61362_});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return FramedCornerSlopePanelBlock.getStateForPlacement(this, ctx, this.getBlockType() == BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL, true);
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, BlockHitResult hit, Rotation rot) {
        Direction side = hit.m_82434_();
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        switch ((BlockType)this.getBlockType()) {
            case FRAMED_EXT_CORNER_SLOPE_PANEL: {
                if (side != dir.m_122424_() && side != dir.m_122427_()) break;
                side = Direction.UP;
                break;
            }
            case FRAMED_EXT_INNER_CORNER_SLOPE_PANEL: {
                if (side != dir && side != dir.m_122428_()) break;
                boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
                Vec3 hitVec = hit.m_82450_();
                double y = Utils.fractionInDir(hitVec, top ? Direction.UP : Direction.DOWN);
                double xz = Utils.fractionInDir(hitVec, side == dir ? dir.m_122428_() : dir) - 0.5;
                if (!(xz * 2.0 > y)) break;
                side = Direction.UP;
            }
        }
        return this.rotate(state, side, rot);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        if (Utils.isY(face)) {
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            return (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)rot.m_55954_(dir));
        }
        return (BlockState)state.m_61122_((Property)FramedProperties.TOP);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return this.rotate(state, Direction.UP, rotation);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return Utils.mirrorCornerBlock(state, mirror);
    }

    @Override
    public BlockItem createBlockItem() {
        Block other = switch ((BlockType)this.getBlockType()) {
            case BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL -> (Block)FBContent.BLOCK_FRAMED_EXTENDED_CORNER_SLOPE_PANEL_WALL.get();
            case BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL -> (Block)FBContent.BLOCK_FRAMED_EXTENDED_INNER_CORNER_SLOPE_PANEL_WALL.get();
            default -> throw new IllegalStateException("Unexpected type: " + this.getBlockType());
        };
        return new VerticalAndWallBlockItem(this, other, new Item.Properties());
    }
}

