/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.blockentity.special;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.ChiseledBookShelfBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import xfacthd.framedblocks.api.block.FramedBlockEntity;
import xfacthd.framedblocks.common.FBContent;

public class FramedChiseledBookshelfBlockEntity
extends FramedBlockEntity {
    public static final String INVENTORY_NBT_KEY = "inventory";
    public static final String LAST_SLOT_NBT_KEY = "last_slot";
    private final ItemStackHandler itemHandler = new ItemStackHandler(6);
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private int lastInteractedSlot = -1;

    public FramedChiseledBookshelfBlockEntity(BlockPos pos, BlockState state) {
        super(FBContent.BE_TYPE_FRAMED_CHISELED_BOOKSHELF.get(), pos, state);
    }

    public void placeBook(ItemStack stack, int slot) {
        this.itemHandler.setStackInSlot(slot, stack);
        this.updateState(slot);
        this.m_6596_();
    }

    public ItemStack takeBook(int slot) {
        ItemStack stack = this.itemHandler.getStackInSlot(slot);
        this.itemHandler.setStackInSlot(slot, ItemStack.f_41583_);
        this.updateState(slot);
        this.m_6596_();
        return stack;
    }

    private void updateState(int slot) {
        this.lastInteractedSlot = slot;
        BlockState state = this.m_58900_();
        for (int i = 0; i < 6; ++i) {
            BooleanProperty prop = (BooleanProperty)ChiseledBookShelfBlock.f_260698_.get(i);
            state = (BlockState)state.m_61124_((Property)prop, (Comparable)Boolean.valueOf(!this.itemHandler.getStackInSlot(i).m_41619_()));
        }
        this.f_58857_.m_46597_(this.f_58858_, state);
    }

    public void forceStateUpdate() {
        this.updateState(this.lastInteractedSlot);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    public List<ItemStack> getDrops() {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            drops.add(stack);
        }
        return drops;
    }

    public void clearContents() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    public int getAnalogOutputSignal() {
        return this.lastInteractedSlot + 1;
    }

    @Override
    public CompoundTag writeToBlueprint() {
        CompoundTag tag = this.m_187482_();
        tag.m_128473_(INVENTORY_NBT_KEY);
        tag.m_128473_(LAST_SLOT_NBT_KEY);
        return tag;
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        nbt.m_128365_(INVENTORY_NBT_KEY, (Tag)this.itemHandler.serializeNBT());
        nbt.m_128405_(LAST_SLOT_NBT_KEY, this.lastInteractedSlot);
        super.m_183515_(nbt);
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_(INVENTORY_NBT_KEY));
        this.lastInteractedSlot = nbt.m_128451_(LAST_SLOT_NBT_KEY);
    }
}

