/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.blockentity.special;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Clearable;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import xfacthd.framedblocks.api.block.FramedBlockEntity;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.menu.FramedStorageMenu;

public class FramedStorageBlockEntity
extends FramedBlockEntity
implements MenuProvider,
Nameable,
Clearable {
    public static final Component TITLE = Utils.translate("title", "framed_secret_storage");
    public static final String INVENTORY_NBT_KEY = "inventory";
    private final ItemStackHandler itemHandler = new ItemStackHandler(36){

        protected void onContentsChanged(int slot) {
            FramedStorageBlockEntity.this.m_6596_();
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private Component customName = null;

    public FramedStorageBlockEntity(BlockPos pos, BlockState state) {
        super(FBContent.BE_TYPE_FRAMED_SECRET_STORAGE.get(), pos, state);
    }

    protected FramedStorageBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void open(ServerPlayer player) {
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)this, (BlockPos)this.f_58858_);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    public boolean isUsableByPlayer(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return !(player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) > 64.0);
    }

    public List<ItemStack> getDrops() {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            drops.add(stack);
        }
        return drops;
    }

    public void m_6211_() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    public int getAnalogOutputSignal() {
        int stacks = 0;
        float fullness = 0.0f;
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            float sizeLimit = Math.min(this.itemHandler.getSlotLimit(i), stack.m_41741_());
            fullness += (float)stack.m_41613_() / sizeLimit;
            ++stacks;
        }
        return Mth.m_14143_((float)((fullness /= (float)this.itemHandler.getSlots()) * 14.0f)) + (stacks > 0 ? 1 : 0);
    }

    public void setCustomName(Component customName) {
        this.customName = customName;
        this.m_6596_();
    }

    public Component m_7755_() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    public Component m_7770_() {
        return this.customName;
    }

    @Override
    public CompoundTag writeToBlueprint() {
        CompoundTag tag = this.m_187482_();
        tag.m_128473_(INVENTORY_NBT_KEY);
        tag.m_128473_("custom_name");
        return tag;
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        nbt.m_128365_(INVENTORY_NBT_KEY, (Tag)this.itemHandler.serializeNBT());
        if (this.customName != null) {
            nbt.m_128359_("custom_name", Component.Serializer.m_130703_((Component)this.customName));
        }
        super.m_183515_(nbt);
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_(INVENTORY_NBT_KEY));
        if (nbt.m_128425_("custom_name", 8)) {
            this.customName = Component.Serializer.m_130701_((String)nbt.m_128461_("custom_name"));
        }
    }

    protected Component getDefaultName() {
        return TITLE;
    }

    public final Component m_5446_() {
        return this.m_7755_();
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new FramedStorageMenu(windowId, inv, this);
    }
}

