/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.compat.rei;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import me.shedaniel.rei.api.client.registry.display.DynamicDisplayGenerator;
import me.shedaniel.rei.api.client.view.ViewSearchBuilder;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.compat.rei.FramingSawDisplay;
import xfacthd.framedblocks.common.compat.rei.FramingSawRecipeCategory;
import xfacthd.framedblocks.common.crafting.FramingSawRecipe;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeAdditive;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeCache;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeCalculation;

public final class FramingSawDisplayGenerator
implements DynamicDisplayGenerator<FramingSawDisplay> {
    public Optional<List<FramingSawDisplay>> getRecipeFor(EntryStack<?> entry) {
        if (!entry.isEmpty() && entry.getType() == VanillaEntryTypes.ITEM) {
            ItemStack input = new ItemStack((ItemLike)FBContent.BLOCK_FRAMED_CUBE.get());
            ItemStack output = (ItemStack)entry.castValue();
            FramingSawRecipe recipe = FramingSawRecipeCache.get(true).findRecipeFor(output);
            if (recipe != null) {
                return Optional.of(List.of(FramingSawDisplayGenerator.makeDisplay(recipe, input)));
            }
        }
        return Optional.empty();
    }

    public Optional<List<FramingSawDisplay>> getUsageFor(EntryStack<?> entry) {
        if (!entry.isEmpty() && entry.getType() == VanillaEntryTypes.ITEM) {
            ItemStack input = (ItemStack)entry.castValue();
            if (input.m_150930_(((Block)FBContent.BLOCK_FRAMING_SAW.get()).m_5456_()) || input.m_150930_(((Block)FBContent.BLOCK_POWERED_FRAMING_SAW.get()).m_5456_())) {
                return this.getUsageFor(EntryStacks.of((ItemLike)((ItemLike)FBContent.BLOCK_FRAMED_CUBE.get())));
            }
            FramingSawRecipeCache cache = FramingSawRecipeCache.get(true);
            if (cache.getMaterialValue(input.m_41720_()) > -1) {
                List<FramingSawRecipe> recipes = cache.getRecipes();
                ArrayList<FramingSawDisplay> displays = new ArrayList<FramingSawDisplay>(recipes.size());
                for (FramingSawRecipe recipe : recipes) {
                    displays.add(FramingSawDisplayGenerator.makeDisplay(recipe, input));
                }
                return Optional.of(displays);
            }
            List<FramingSawRecipe> recipes = cache.getRecipesWithAdditive(input);
            if (!recipes.isEmpty()) {
                ArrayList<FramingSawDisplay> displays = new ArrayList<FramingSawDisplay>(recipes.size());
                input = new ItemStack((ItemLike)FBContent.BLOCK_FRAMED_CUBE.get());
                for (FramingSawRecipe recipe : recipes) {
                    displays.add(FramingSawDisplayGenerator.makeDisplay(recipe, input));
                }
                return Optional.of(displays);
            }
        }
        return Optional.empty();
    }

    public Optional<List<FramingSawDisplay>> generate(ViewSearchBuilder builder) {
        if (builder.getUsagesFor().isEmpty() && builder.getRecipesFor().isEmpty() && builder.getCategories().contains(FramingSawRecipeCategory.SAW_CATEGORY)) {
            return this.getUsageFor(EntryStacks.of((ItemLike)((ItemLike)FBContent.BLOCK_FRAMED_CUBE.get())));
        }
        return Optional.empty();
    }

    private static FramingSawDisplay makeDisplay(FramingSawRecipe recipe, ItemStack input) {
        boolean inputWithAdditives = FramingSawRecipeCache.get(true).containsAdditive(input.m_41720_());
        List<FramingSawRecipeAdditive> additives = recipe.getAdditives();
        ArrayList<EntryIngredient> inputs = new ArrayList<EntryIngredient>(additives.size() + 1);
        FramingSawRecipeCalculation calc = recipe.makeCraftingCalculation((Container)new SimpleContainer(new ItemStack[]{input}), true);
        int outputCount = calc.getOutputCount();
        ItemStack inputStack = input.m_41777_();
        inputStack.m_41764_(calc.getInputCount());
        inputs.add(EntryIngredient.of((EntryStack)EntryStacks.of((ItemStack)inputStack)));
        for (FramingSawRecipeAdditive additive : additives) {
            int addCount = additive.count() * (outputCount / recipe.getResult().m_41613_());
            List<EntryStack> additiveStacks = Stream.of(additive.ingredient().m_43908_()).map(ItemStack::m_41777_).peek(s -> s.m_41764_(addCount)).map(EntryStacks::of).toList();
            inputs.add(EntryIngredient.of(additiveStacks));
        }
        ItemStack result = recipe.getResult().m_41777_();
        result.m_41764_(outputCount);
        EntryIngredient output = EntryIngredient.of((EntryStack)EntryStacks.of((ItemStack)result));
        return new FramingSawDisplay(recipe, inputs, output, inputWithAdditives);
    }
}

