/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data;

import com.google.common.base.Stopwatch;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraftforge.registries.ForgeRegistries;
import xfacthd.framedblocks.FramedBlocks;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.block.cache.IStateCacheAccessor;
import xfacthd.framedblocks.api.block.cache.StateCache;

public final class StateCacheBuilder {
    private static volatile boolean cachesBuilt = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void ensureStateCachesInitialized() {
        if (cachesBuilt) return;
        Class<StateCacheBuilder> clazz = StateCacheBuilder.class;
        synchronized (StateCacheBuilder.class) {
            if (cachesBuilt) return;
            StateCacheBuilder.initializeStateCaches();
            cachesBuilt = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static void initializeStateCaches() {
        FramedBlocks.LOGGER.debug("Initializing custom state metadata caches");
        Stopwatch watch = Stopwatch.createStarted();
        long[] counts = new long[]{0L, 1L};
        ForgeRegistries.BLOCKS.getValues().stream().filter(block -> block instanceof IFramedBlock).map(Block::m_49965_).map(StateDefinition::m_61056_).forEach(states -> {
            HashMap<StateCache, StateCache> cacheDedup = new HashMap<StateCache, StateCache>();
            for (BlockState state : states) {
                StateCache cache = ((IFramedBlock)state.m_60734_()).initCache(state);
                if (cache.equals(StateCache.EMPTY)) {
                    ((IStateCacheAccessor)state).framedblocks$initCache(StateCache.EMPTY);
                    continue;
                }
                ((IStateCacheAccessor)state).framedblocks$initCache(Objects.requireNonNullElse(cacheDedup.putIfAbsent(cache, cache), cache));
            }
            counts[0] = counts[0] + (long)states.size();
            counts[1] = counts[1] + (long)cacheDedup.size();
        });
        watch.stop();
        FramedBlocks.LOGGER.debug("Initialized {} unique caches for {} states in {}", new Object[]{counts[1], counts[0], watch});
    }

    private StateCacheBuilder() {
    }

    public static final class CacheReloader
    implements ResourceManagerReloadListener {
        public static final CacheReloader INSTANCE = new CacheReloader();

        private CacheReloader() {
        }

        public void m_6213_(ResourceManager mgr) {
            StateCacheBuilder.initializeStateCaches();
        }
    }
}

