/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.pillar;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.skippreds.CullTest;

@CullTest(value={BlockType.FRAMED_HALF_PILLAR})
public final class HalfPillarSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object;
        Direction face = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        if (side == face && (object = adjState.m_60734_()) instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            return switch (type) {
                case BlockType.FRAMED_HALF_PILLAR -> HalfPillarSkipPredicate.testAgainstHalfPillar(adjState, side);
                case BlockType.FRAMED_PILLAR -> HalfPillarSkipPredicate.testAgainstPillar(adjState, side);
                case BlockType.FRAMED_WALL -> HalfPillarSkipPredicate.testAgainstWall(adjState, side);
                case BlockType.FRAMED_THICK_LATTICE -> HalfPillarSkipPredicate.testAgainstThickLattice(adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_HALF_PILLAR})
    private static boolean testAgainstHalfPillar(BlockState adjState, Direction side) {
        return adjState.m_61143_((Property)BlockStateProperties.f_61372_) == side.m_122424_();
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_PILLAR})
    private static boolean testAgainstPillar(BlockState adjState, Direction side) {
        return adjState.m_61143_((Property)BlockStateProperties.f_61365_) == side.m_122434_();
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_WALL})
    private static boolean testAgainstWall(BlockState adjState, Direction side) {
        return Utils.isY(side) && (Boolean)adjState.m_61143_((Property)BlockStateProperties.f_61366_) != false;
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_THICK_LATTICE})
    private static boolean testAgainstThickLattice(BlockState adjState, Direction side) {
        return switch (side.m_122434_()) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> (Boolean)adjState.m_61143_((Property)FramedProperties.X_AXIS);
            case Direction.Axis.Y -> (Boolean)adjState.m_61143_((Property)FramedProperties.Y_AXIS);
            case Direction.Axis.Z -> (Boolean)adjState.m_61143_((Property)FramedProperties.Z_AXIS);
        };
    }
}

