/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.blockentity;

import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.FakePlayer;
import thedarkcolour.exdeorum.blockentity.EBlockEntity;
import thedarkcolour.exdeorum.blockentity.logic.SieveLogic;
import thedarkcolour.exdeorum.config.EConfig;

public abstract class AbstractSieveBlockEntity
extends EBlockEntity
implements SieveLogic.Owner {
    protected final SieveLogic logic;
    private final float sieveInterval;

    public AbstractSieveBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, float sieveInterval, Function<SieveLogic.Owner, SieveLogic> logic) {
        super(type, pos, state);
        this.sieveInterval = sieveInterval;
        this.logic = logic.apply(this);
    }

    public static ItemStack singleCopy(ItemStack stack) {
        ItemStack copy = stack.m_41777_();
        copy.m_41764_(1);
        return copy;
    }

    @Override
    public boolean handleResultItem(ItemStack result, ServerLevel level, RandomSource rand) {
        BlockPos pos = this.f_58858_;
        ItemEntity itemEntity = new ItemEntity((Level)level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.5, (double)pos.m_123343_() + 0.5, result);
        itemEntity.m_20334_(rand.m_188583_() * 0.05, 0.2, rand.m_188583_() * 0.05);
        level.m_7967_((Entity)itemEntity);
        return true;
    }

    @Override
    public ServerLevel getServerLevel() {
        return (ServerLevel)this.f_58857_;
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        this.logic.saveNbt(nbt);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.logic.loadNbt(nbt);
    }

    @Override
    public SieveLogic getLogic() {
        return this.logic;
    }

    @Override
    public void writeVisualData(FriendlyByteBuf buffer) {
        buffer.m_130055_(this.logic.getMesh());
        buffer.writeFloat(this.logic.getProgress());
        buffer.m_130055_(this.logic.getContents());
    }

    @Override
    public void readVisualData(FriendlyByteBuf buffer) {
        this.logic.setMesh(buffer.m_130267_(), false);
        this.logic.setProgress(buffer.readFloat());
        this.logic.setContents(buffer.m_130267_());
    }

    @Override
    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        boolean isClientSide;
        block21: {
            ItemStack playerItem = player.m_21120_(hand);
            isClientSide = level.f_46443_;
            if (this.logic.getMesh().m_41619_()) {
                if (this.logic.isValidMesh(playerItem)) {
                    if (!isClientSide) {
                        this.logic.setMesh(AbstractSieveBlockEntity.singleCopy(playerItem));
                        if (!player.m_150110_().f_35937_) {
                            playerItem.m_41774_(1);
                        }
                        return InteractionResult.CONSUME;
                    }
                    return InteractionResult.SUCCESS;
                }
            } else if (this.logic.getContents().m_41619_() && player.m_6144_() && player.m_21205_().m_41619_()) {
                AbstractSieveBlockEntity.popOutMesh(level, this.f_58858_, this.logic);
            }
            if (!isClientSide) {
                if (this.logic.getContents().m_41619_()) {
                    if (this.logic.isValidInput(playerItem)) {
                        Item usedItem = playerItem.m_41720_();
                        boolean realPlayer = !(player instanceof FakePlayer);
                        AbstractSieveBlockEntity.insertContents(player, playerItem, this.logic);
                        if ((realPlayer || !((Boolean)EConfig.SERVER.nerfAutomatedSieves.get()).booleanValue()) && this.canUseSimultaneously()) {
                            int range = (Integer)EConfig.SERVER.simultaneousSieveUsageRange.get();
                            BlockPos.MutableBlockPos cursor = this.f_58858_.m_122032_().m_122184_(-range, 0, -range);
                            BlockEntityType selfType = this.m_58903_();
                            for (int x = -range; x <= range; ++x) {
                                for (int z = -range; z <= range; ++z) {
                                    if (!playerItem.m_41619_() || !(playerItem = AbstractSieveBlockEntity.restockSieveMaterial(player, hand, usedItem)).m_41619_()) {
                                        SieveLogic otherLogic;
                                        AbstractSieveBlockEntity other;
                                        BlockEntity blockEntity;
                                        if ((x | z) != 0 && (blockEntity = level.m_7702_((BlockPos)cursor)) instanceof AbstractSieveBlockEntity && (other = (AbstractSieveBlockEntity)blockEntity).m_58903_() == selfType && (otherLogic = other.logic).getContents().m_41619_() && this.logic.getMesh().m_41720_() == otherLogic.getMesh().m_41720_()) {
                                            AbstractSieveBlockEntity.insertContents(player, playerItem, otherLogic);
                                        }
                                        cursor.m_122184_(0, 0, 1);
                                        continue;
                                    }
                                    break block21;
                                }
                                cursor.m_122184_(1, 0, -2 * range - 1);
                            }
                        }
                    }
                } else {
                    boolean realPlayer;
                    long time = level.m_46467_();
                    boolean bl = realPlayer = !(player instanceof FakePlayer);
                    if ((realPlayer || !((Boolean)EConfig.SERVER.nerfAutomatedSieves.get()).booleanValue()) && this.canUseSimultaneously()) {
                        int range = (Integer)EConfig.SERVER.simultaneousSieveUsageRange.get();
                        BlockPos.MutableBlockPos cursor = this.f_58858_.m_122032_().m_122184_(-range, 0, -range);
                        BlockEntityType selfType = this.m_58903_();
                        for (int x = -range; x <= range; ++x) {
                            for (int z = -range; z <= range; ++z) {
                                SieveLogic otherLogic;
                                AbstractSieveBlockEntity other;
                                BlockEntity blockEntity = level.m_7702_((BlockPos)cursor);
                                if (blockEntity instanceof AbstractSieveBlockEntity && (other = (AbstractSieveBlockEntity)blockEntity).m_58903_() == selfType && !(otherLogic = other.logic).getContents().m_41619_() && this.logic.getMesh().m_41720_() == otherLogic.getMesh().m_41720_()) {
                                    otherLogic.sift(this.sieveInterval, time);
                                }
                                cursor.m_122184_(0, 0, 1);
                            }
                            cursor.m_122184_(1, 0, -2 * range - 1);
                        }
                    } else if (realPlayer || ((Boolean)EConfig.SERVER.automatedSieves.get()).booleanValue()) {
                        this.logic.sift(this.sieveInterval, time);
                    }
                }
            }
        }
        return InteractionResult.m_19078_((boolean)isClientSide);
    }

    private static ItemStack restockSieveMaterial(Player player, InteractionHand hand, Item usedItem) {
        Inventory inventory = player.m_150109_();
        int inventorySize = inventory.m_6643_();
        for (int i = 0; i < inventorySize; ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (!stack.m_150930_(usedItem)) continue;
            stack = stack.m_41777_();
            player.m_21008_(hand, stack);
            inventory.m_6836_(i, ItemStack.f_41583_);
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public static void insertContents(Player player, ItemStack playerItem, SieveLogic logic) {
        boolean consume = !player.m_150110_().f_35937_;
        logic.startSifting(AbstractSieveBlockEntity.singleCopy(playerItem));
        player.m_36246_(Stats.f_12982_.m_12902_((Object)playerItem.m_41720_()));
        if (consume) {
            playerItem.m_41774_(1);
        }
    }

    public static void popOutMesh(Level level, BlockPos sievePos, SieveLogic logic) {
        if (!level.f_46443_) {
            ItemEntity itemEntity = new ItemEntity(level, (double)sievePos.m_123341_() + 0.5, (double)sievePos.m_123342_() + 1.5, (double)sievePos.m_123343_() + 0.5, logic.getMesh());
            RandomSource rand = level.f_46441_;
            itemEntity.m_20334_(rand.m_188583_() * 0.05, 0.2, rand.m_188583_() * 0.05);
            level.m_7967_((Entity)itemEntity);
            logic.setMesh(ItemStack.f_41583_);
        }
    }

    protected boolean canUseSimultaneously() {
        return false;
    }
}

