/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.compat.emi;

import com.google.common.collect.ImmutableList;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import thedarkcolour.exdeorum.recipe.BlockPredicate;
import thedarkcolour.exdeorum.recipe.SingleIngredientRecipe;

class EmiUtil {
    EmiUtil() {
    }

    static List<EmiIngredient> inputs(SingleIngredientRecipe recipe) {
        return ImmutableList.of((Object)EmiIngredient.of((Ingredient)recipe.getIngredient()));
    }

    static List<EmiIngredient> inputs(BlockPredicate predicate) {
        if (predicate instanceof BlockPredicate.SingleBlockPredicate) {
            BlockPredicate.SingleBlockPredicate block = (BlockPredicate.SingleBlockPredicate)predicate;
            Item item = block.block().m_5456_();
            if (item != Items.f_41852_) {
                return ImmutableList.of((Object)EmiStack.of((ItemLike)item));
            }
        } else {
            ImmutableList.Builder builder = ImmutableList.builder();
            HashSet items = new HashSet();
            predicate.possibleStates().forEach(state -> {
                Item item = state.m_60734_().m_5456_();
                if (item != Items.f_41852_ && items.add(item)) {
                    builder.add((Object)EmiStack.of((ItemLike)item));
                }
            });
            return ImmutableList.of((Object)EmiIngredient.of((List)builder.build()));
        }
        return ImmutableList.of();
    }

    public static <C extends Container, R extends Recipe<C>> void addAll(EmiRegistry registry, Supplier<RecipeType<R>> type, Function<R, ? extends EmiRecipe> factory) {
        for (Recipe value : registry.getRecipeManager().m_44054_(type.get()).values()) {
            registry.addRecipe(factory.apply(value));
        }
    }

    public static EmiStack fluid(Fluid fluid, int amount) {
        return EmiStack.of((Fluid)fluid, null, (long)amount);
    }

    public static List<EmiStack> outputs(Item result) {
        return ImmutableList.of((Object)EmiStack.of((ItemLike)result));
    }

    public static List<EmiStack> outputs(FluidStack stack) {
        return ImmutableList.of((Object)EmiUtil.fluid(stack.getFluid(), stack.getAmount()));
    }
}

