/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.compat.jei;

import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import thedarkcolour.exdeorum.compat.ClientXeiUtil;
import thedarkcolour.exdeorum.compat.jei.ExDeorumJeiPlugin;
import thedarkcolour.exdeorum.recipe.barrel.BarrelCompostRecipe;

class BarrelCompostCategory
implements IRecipeCategory<BarrelCompostRecipe> {
    private final IDrawable background;
    private final IDrawable slot;
    private final IDrawable icon;
    private final Component title;

    public BarrelCompostCategory(IGuiHelper helper) {
        this.background = helper.createBlankDrawable(120, 18);
        this.slot = helper.getSlotDrawable();
        this.icon = new DrawableIcon();
        this.title = Component.m_237115_((String)"gui.exdeorum.category.barrel_compost");
    }

    public RecipeType<BarrelCompostRecipe> getRecipeType() {
        return ExDeorumJeiPlugin.BARREL_COMPOST;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, BarrelCompostRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addIngredients(recipe.getIngredient());
    }

    public void draw(BarrelCompostRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        this.slot.draw(graphics);
        int volume = recipe.getVolume();
        MutableComponent volumeLabel = Component.m_237110_((String)"gui.exdeorum.category.barrel_compost.volume", (Object[])new Object[]{volume});
        graphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)volumeLabel, 24, 5, -8355712, false);
    }

    private static class DrawableIcon
    implements IDrawable {
        private DrawableIcon() {
        }

        public int getWidth() {
            return 16;
        }

        public int getHeight() {
            return 16;
        }

        public void draw(GuiGraphics guiGraphics, int xOffset, int yOffset) {
            ClientXeiUtil.renderFilledCompostBarrel(guiGraphics, xOffset, yOffset);
        }
    }
}

