/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.compat.top;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITextStyle;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.IFluidTank;
import thedarkcolour.exdeorum.blockentity.AbstractCrucibleBlockEntity;
import thedarkcolour.exdeorum.blockentity.BarrelBlockEntity;
import thedarkcolour.exdeorum.blockentity.InfestedLeavesBlockEntity;
import thedarkcolour.exdeorum.blockentity.SieveBlockEntity;
import thedarkcolour.exdeorum.blockentity.logic.SieveLogic;
import thedarkcolour.exdeorum.registry.EBlocks;

public class ExDeorumInfoProvider
implements IProbeInfoProvider {
    public ResourceLocation getID() {
        return new ResourceLocation("exdeorum", "info_provider");
    }

    public void addProbeInfo(ProbeMode probeMode, IProbeInfo info, Player playerEntity, Level level, BlockState state, IProbeHitData data) {
        BlockEntity te = level.m_7702_(data.getPos());
        if (state.m_60734_() == EBlocks.INFESTED_LEAVES.get()) {
            if (te instanceof InfestedLeavesBlockEntity) {
                InfestedLeavesBlockEntity leaves = (InfestedLeavesBlockEntity)te;
                int progress = (int)(leaves.getProgress() * 100.0f);
                info.text(CompoundText.create().style(TextStyleClass.LABEL).text("Progress: ").style(TextStyleClass.WARNING).text(progress + "%"));
            }
        } else if (te instanceof BarrelBlockEntity) {
            BarrelBlockEntity barrel = (BarrelBlockEntity)te;
            short volume = barrel.compost;
            if (volume == 1000 || barrel.isBrewing()) {
                int progress = (int)(barrel.progress * 100.0f);
                if (progress == 100) {
                    info.text((Component)Component.m_237115_((String)"block.exdeorum.infested_leaves.fully_infested").m_130940_(ChatFormatting.GRAY));
                } else {
                    info.text(CompoundText.create().style(TextStyleClass.LABEL).text("Progress: ").style(TextStyleClass.WARNING).text(progress + "%"));
                }
            } else if (volume > 0) {
                int volumePercent = (int)((float)volume / 10.0f);
                info.text(CompoundText.create().style(TextStyleClass.LABEL).text("Volume: ").style(TextStyleClass.WARNING).text(volumePercent + "%"));
            } else if (barrel.isBurning()) {
                int progress = 300 - (int)(barrel.progress * 300.0f);
                info.text(CompoundText.create().style(TextStyleClass.ERROR).text("Burning! ").style(TextStyleClass.WARNING).text(progress / 20 + "s"));
            }
            if (playerEntity.m_6144_()) {
                info.tank(barrel.getTank());
            }
        } else if (te instanceof AbstractCrucibleBlockEntity) {
            AbstractCrucibleBlockEntity crucible = (AbstractCrucibleBlockEntity)te;
            info.text(CompoundText.create().style(TextStyleClass.LABEL).text("Rate: ").style(TextStyleClass.WARNING).text(crucible.getMeltingRate() + "x"));
            if (playerEntity.m_6144_()) {
                info.tank((IFluidTank)crucible.getTank());
            }
        } else if (te instanceof SieveBlockEntity) {
            SieveBlockEntity sieve = (SieveBlockEntity)te;
            SieveLogic logic = sieve.getLogic();
            if (!logic.getContents().m_41619_()) {
                info.text(CompoundText.create().style(TextStyleClass.LABEL).text("Progress: ").style(TextStyleClass.WARNING).text(Math.round(1000.0f * logic.getProgress()) / 10 + "%"));
            }
            if (playerEntity.m_6144_()) {
                ItemStack mesh = logic.getMesh();
                info.horizontal(info.defaultLayoutStyle().spacing(10).alignment(ElementAlignment.ALIGN_CENTER)).item(mesh, info.defaultItemStyle().width(16).height(16)).text(CompoundText.create().info(mesh.m_41778_()));
                if (mesh.m_41793_()) {
                    ObjectArrayList list = new ObjectArrayList();
                    ITextStyle style = info.defaultTextStyle().height(Integer.valueOf(10));
                    ItemStack.m_41709_((List)list, (ListTag)mesh.m_41785_());
                    for (Component component : list) {
                        info.text(component, style);
                    }
                }
            }
        }
    }
}

