/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.loot;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import thedarkcolour.exdeorum.recipe.RecipeUtil;
import thedarkcolour.exdeorum.recipe.crook.CrookRecipe;

public class CrookLootModifier
extends LootModifier {
    public static final Codec<CrookLootModifier> CODEC = RecordCodecBuilder.create(inst -> LootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, CrookLootModifier::new));

    protected CrookLootModifier(LootItemCondition[] conditions) {
        super(conditions);
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        BlockState state = (BlockState)context.m_78953_(LootContextParams.f_81461_);
        ItemStack stack = (ItemStack)context.m_78953_(LootContextParams.f_81463_);
        if (state != null && stack != null) {
            RandomSource rand = context.m_230907_();
            if (stack.getEnchantmentLevel(Enchantments.f_44985_) == 0) {
                int fortune = stack.getEnchantmentLevel(Enchantments.f_44987_);
                int rolls = Math.max(1, Mth.m_14167_((float)((float)fortune / 3.0f)));
                for (CrookRecipe recipe : RecipeUtil.getCrookRecipes(state)) {
                    for (int i = 0; i < rolls; ++i) {
                        if (!(rand.m_188501_() < recipe.chance())) continue;
                        ItemStack result = new ItemStack((ItemLike)recipe.result(), 1);
                        result.m_41751_(recipe.getResultNbt());
                        generatedLoot.add((Object)result);
                    }
                }
                if (state.m_204336_(BlockTags.f_13035_)) {
                    ItemStack nonCrook = new ItemStack((ItemLike)Items.f_42127_);
                    nonCrook.m_41751_(stack.m_41783_());
                    for (int i = 0; i < rolls; ++i) {
                        generatedLoot.addAll(CrookLootModifier.reRollDrops(context, nonCrook, state));
                    }
                }
            }
        }
        return generatedLoot;
    }

    private static List<ItemStack> reRollDrops(LootContext context, ItemStack nonCrook, BlockState state) {
        LootParams.Builder builder = new LootParams.Builder(context.m_78952_());
        builder.m_287286_(LootContextParams.f_81461_, (Object)((BlockState)context.m_165124_(LootContextParams.f_81461_)));
        builder.m_287286_(LootContextParams.f_81463_, (Object)nonCrook);
        if (context.m_78936_(LootContextParams.f_81455_)) {
            builder.m_287286_(LootContextParams.f_81455_, (Object)((Entity)context.m_165124_(LootContextParams.f_81455_)));
        }
        if (context.m_78936_(LootContextParams.f_81460_)) {
            builder.m_287286_(LootContextParams.f_81460_, (Object)((Vec3)context.m_165124_(LootContextParams.f_81460_)));
        }
        return state.m_287290_(builder);
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

