/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.loot;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.exdeorum.recipe.RecipeUtil;
import thedarkcolour.exdeorum.recipe.hammer.HammerRecipe;

public class HammerLootModifier
extends LootModifier {
    public static final Codec<HammerLootModifier> CODEC = RecordCodecBuilder.create(inst -> LootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, HammerLootModifier::new));

    protected HammerLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        HammerRecipe recipe;
        Item itemForm;
        BlockState state = (BlockState)context.m_78953_(LootContextParams.f_81461_);
        if (state != null && (itemForm = state.m_60734_().m_5456_()) != Items.f_41852_ && (recipe = this.getRecipe(itemForm)) != null) {
            ObjectArrayList newLoot = new ObjectArrayList();
            int resultAmount = recipe.resultAmount.m_142683_(context);
            if (context.m_78936_(LootContextParams.f_81463_)) {
                ItemStack hammer = (ItemStack)context.m_165124_(LootContextParams.f_81463_);
                resultAmount += HammerLootModifier.calculateFortuneBonus(hammer, context.m_230907_(), resultAmount == 0);
            }
            if (resultAmount > 0) {
                ItemStack result = new ItemStack((ItemLike)recipe.result, resultAmount);
                result.m_41751_(recipe.getResultNbt());
                newLoot.add((Object)result);
            }
            return newLoot;
        }
        return generatedLoot;
    }

    @Nullable
    protected HammerRecipe getRecipe(Item itemForm) {
        return RecipeUtil.getHammerRecipe(itemForm);
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }

    public static int calculateFortuneBonus(ItemStack hammer, RandomSource rand, boolean zeroBaseDrops) {
        int fortune = hammer.getEnchantmentLevel(Enchantments.f_44987_);
        if (fortune != 0) {
            float chance = rand.m_188501_();
            if (zeroBaseDrops ? chance < 0.06f * (float)fortune : chance < 0.03f * (float)fortune) {
                return 1;
            }
        }
        return 0;
    }
}

