/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.material;

import com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.exdeorum.material.AbstractMaterial;
import thedarkcolour.exdeorum.material.DefaultMaterials;
import thedarkcolour.exdeorum.material.MaterialParser;

public abstract class AbstractCrucibleMaterial
extends AbstractMaterial {
    public static final Set<Block> TRANSPARENT_CRUCIBLES = new HashSet<Block>();
    public final boolean transparent;

    public AbstractCrucibleMaterial(SoundType soundType, float strength, boolean needsCorrectTool, int mapColor, String requiredModId, boolean transparent) {
        super(soundType, strength, needsCorrectTool, mapColor, requiredModId);
        this.transparent = transparent;
    }

    @Nullable
    public static <T extends AbstractCrucibleMaterial> T readFromJson(MaterialParser parser, Factory<T> factory) {
        SoundType soundType = parser.getSoundType();
        float strength = parser.getStrength();
        boolean needsCorrectTool = parser.getOptionalBoolean("needs_correct_tool");
        int mapColor = parser.getMapColor();
        String requiredModId = parser.getRequiredModId();
        boolean transparent = parser.getOptionalBoolean("transparent");
        if (parser.error) {
            return null;
        }
        return (T)((AbstractCrucibleMaterial)factory.create(soundType, strength, needsCorrectTool, mapColor, requiredModId, transparent));
    }

    public static void loadTransparentBlocks() {
        for (AbstractCrucibleMaterial material : Iterables.concat(DefaultMaterials.WATER_CRUCIBLES, DefaultMaterials.LAVA_CRUCIBLES)) {
            TRANSPARENT_CRUCIBLES.add(material.getBlock());
        }
    }

    public static interface Factory<T> {
        public T create(SoundType var1, float var2, boolean var3, int var4, String var5, boolean var6);
    }
}

