/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.recipe.barrel;

import com.google.gson.JsonObject;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.exdeorum.recipe.RecipeUtil;
import thedarkcolour.exdeorum.recipe.SingleIngredientRecipe;
import thedarkcolour.exdeorum.registry.ERecipeSerializers;
import thedarkcolour.exdeorum.registry.ERecipeTypes;

public class BarrelMixingRecipe
extends SingleIngredientRecipe {
    public final Fluid fluid;
    public final int fluidAmount;
    public final Item result;
    @Nullable
    protected final CompoundTag resultNbt;

    public BarrelMixingRecipe(ResourceLocation id, Ingredient ingredient, Fluid fluid, int fluidAmount, Item result, @Nullable CompoundTag resultNbt) {
        super(id, ingredient);
        this.fluid = fluid;
        this.fluidAmount = fluidAmount;
        this.result = result;
        this.resultNbt = resultNbt;
    }

    @Nullable
    public CompoundTag getResultNbt() {
        return this.resultNbt == null ? null : this.resultNbt.m_6426_();
    }

    @Override
    @Deprecated
    public boolean m_5818_(Container inventory, Level level) {
        return false;
    }

    public boolean matches(ItemStack item, FluidStack fluid) {
        return this.ingredient.test(item) && fluid.getFluid() == this.fluid && fluid.getAmount() >= this.fluidAmount;
    }

    @Override
    public ItemStack m_8043_(RegistryAccess access) {
        return new ItemStack((ItemLike)this.result);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ERecipeSerializers.BARREL_MIXING.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ERecipeTypes.BARREL_MIXING.get();
    }

    public static class Serializer
    implements RecipeSerializer<BarrelMixingRecipe> {
        public BarrelMixingRecipe fromJson(ResourceLocation id, JsonObject json) {
            Ingredient ingredient = RecipeUtil.readIngredient(json, "ingredient");
            Fluid fluid = RecipeUtil.readFluid(json, "fluid");
            int fluidAmount = GsonHelper.m_13927_((JsonObject)json, (String)"fluid_amount");
            Item result = RecipeUtil.readItem(json, "result");
            CompoundTag resultNbt = RecipeUtil.readNbtTag(json, "result_nbt");
            return new BarrelMixingRecipe(id, ingredient, fluid, fluidAmount, result, resultNbt);
        }

        public void toNetwork(FriendlyByteBuf buffer, BarrelMixingRecipe recipe) {
            recipe.ingredient.m_43923_(buffer);
            buffer.writeRegistryId(ForgeRegistries.FLUIDS, (Object)recipe.fluid);
            buffer.m_130130_(recipe.fluidAmount);
            buffer.writeRegistryId(ForgeRegistries.ITEMS, (Object)recipe.result);
            buffer.m_130079_(recipe.resultNbt);
        }

        @Nullable
        public BarrelMixingRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            Fluid fluid = (Fluid)buffer.readRegistryId();
            int fluidAmount = buffer.m_130242_();
            Item result = (Item)buffer.readRegistryId();
            CompoundTag resultNbt = buffer.m_130260_();
            return new BarrelMixingRecipe(id, ingredient, fluid, fluidAmount, result, resultNbt);
        }
    }
}

