/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.recipe.crucible;

import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.fluids.FluidStack;
import thedarkcolour.exdeorum.recipe.RecipeUtil;
import thedarkcolour.exdeorum.recipe.SingleIngredientRecipe;
import thedarkcolour.exdeorum.registry.ERecipeSerializers;

public class CrucibleRecipe
extends SingleIngredientRecipe {
    private final RecipeType<?> type;
    private final FluidStack result;

    public CrucibleRecipe(ResourceLocation id, RecipeType<?> type, Ingredient ingredient, FluidStack result) {
        super(id, ingredient);
        this.type = type;
        this.result = result;
        if (this.dependsOnNbt) {
            throw new IllegalArgumentException("Cannot use NBT to determine Ex Deorum Crucible output");
        }
    }

    public FluidStack getResult() {
        return this.result;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ERecipeSerializers.LAVA_CRUCIBLE.get();
    }

    public RecipeType<?> m_6671_() {
        return this.type;
    }

    public static class Serializer
    implements RecipeSerializer<CrucibleRecipe> {
        private final RecipeType<?> type;

        public Serializer(RecipeType<?> type) {
            this.type = type;
        }

        public CrucibleRecipe fromJson(ResourceLocation id, JsonObject json) {
            Ingredient ingredient = RecipeUtil.readIngredient(json, "ingredient");
            FluidStack stack = RecipeUtil.readFluidStack(json, "fluid");
            return new CrucibleRecipe(id, this.type, ingredient, stack);
        }

        @Nullable
        public CrucibleRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            return new CrucibleRecipe(id, this.type, Ingredient.m_43940_((FriendlyByteBuf)buffer), FluidStack.readFromPacket((FriendlyByteBuf)buffer));
        }

        public void toNetwork(FriendlyByteBuf buffer, CrucibleRecipe recipe) {
            recipe.getIngredient().m_43923_(buffer);
            recipe.getResult().writeToPacket(buffer);
        }
    }
}

