/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.voidworld;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import thedarkcolour.exdeorum.config.EConfig;

public class VoidChunkGenerator
extends NoiseBasedChunkGenerator {
    public static final Codec<VoidChunkGenerator> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)BiomeSource.f_47888_.fieldOf("biome_source").forGetter(gen -> gen.f_62137_), (App)NoiseGeneratorSettings.f_64431_.fieldOf("settings").forGetter(gen -> gen.settings), (App)TagKey.m_203877_((ResourceKey)Registries.f_256998_).fieldOf("allowed_structure_sets").forGetter(gen -> gen.allowedStructureSets)).apply((Applicative)inst, inst.stable(VoidChunkGenerator::new)));
    private final Holder<NoiseGeneratorSettings> settings;
    private final TagKey<StructureSet> allowedStructureSets;
    private final boolean generateNormal;
    private final boolean allowBiomeDecoration;

    public VoidChunkGenerator(BiomeSource biomeSource, Holder<NoiseGeneratorSettings> settings, TagKey<StructureSet> allowedStructureSets) {
        super(biomeSource, settings);
        this.settings = settings;
        this.allowedStructureSets = allowedStructureSets;
        this.generateNormal = settings.m_203373_(new ResourceLocation("minecraft:end")) && (Boolean)EConfig.COMMON.voidEndGeneration.get() == false || settings.m_203373_(new ResourceLocation("minecraft:nether")) && (Boolean)EConfig.COMMON.voidNetherGeneration.get() == false;
        this.allowBiomeDecoration = !settings.m_203373_(new ResourceLocation("minecraft:overworld"));
    }

    protected Codec<? extends ChunkGenerator> m_6909_() {
        return CODEC;
    }

    public void m_213679_(WorldGenRegion pLevel, long pSeed, RandomState pRandom, BiomeManager pBiomeManager, StructureManager pStructureManager, ChunkAccess pChunk, GenerationStep.Carving pStep) {
        if (this.generateNormal) {
            super.m_213679_(pLevel, pSeed, pRandom, pBiomeManager, pStructureManager, pChunk, pStep);
        }
    }

    public ChunkGeneratorStructureState m_255169_(HolderLookup<StructureSet> lookup, RandomState pRandomState, long pSeed) {
        return this.generateNormal ? super.m_255169_(lookup, pRandomState, pSeed) : super.m_255169_((HolderLookup)new FilteredLookup(lookup, this.allowedStructureSets), pRandomState, pSeed);
    }

    public void m_214194_(WorldGenRegion pLevel, StructureManager pStructureManager, RandomState pRandom, ChunkAccess pChunk) {
        if (this.generateNormal) {
            super.m_214194_(pLevel, pStructureManager, pRandom, pChunk);
        }
    }

    public void m_6929_(WorldGenRegion pLevel) {
        if (this.generateNormal) {
            super.m_6929_(pLevel);
        }
    }

    public CompletableFuture<ChunkAccess> m_213974_(Executor pExecutor, Blender pBlender, RandomState pRandom, StructureManager pStructureManager, ChunkAccess chunk) {
        if (this.generateNormal) {
            return super.m_213974_(pExecutor, pBlender, pRandom, pStructureManager, chunk);
        }
        return CompletableFuture.completedFuture(chunk);
    }

    public int m_214096_(int pX, int pZ, Heightmap.Types pType, LevelHeightAccessor pLevel, RandomState pRandom) {
        if (this.generateNormal) {
            return super.m_214096_(pX, pZ, pType, pLevel, pRandom);
        }
        return this.m_142062_();
    }

    public NoiseColumn m_214184_(int pX, int pZ, LevelHeightAccessor pHeight, RandomState pRandom) {
        if (this.generateNormal) {
            return super.m_214184_(pX, pZ, pHeight, pRandom);
        }
        return new NoiseColumn(0, new BlockState[0]);
    }

    public void m_213600_(List<String> pInfo, RandomState pRandom, BlockPos pPos) {
        if (this.generateNormal) {
            super.m_213600_(pInfo, pRandom, pPos);
        }
    }

    public void m_213609_(WorldGenLevel pLevel, ChunkAccess pChunk, StructureManager pStructureManager) {
        if (this.generateNormal || this.allowBiomeDecoration) {
            super.m_213609_(pLevel, pChunk, pStructureManager);
        }
    }

    public void m_223076_(WorldGenLevel level, StructureManager pStructureManager, ChunkAccess pChunk) {
        if (this.generateNormal || this.hasStructures(level.m_9598_())) {
            super.m_223076_(level, pStructureManager, pChunk);
        }
    }

    public void m_255037_(RegistryAccess registries, ChunkGeneratorStructureState pStructureState, StructureManager pStructureManager, ChunkAccess pChunk, StructureTemplateManager pStructureTemplateManager) {
        if (this.generateNormal || this.hasStructures(registries)) {
            super.m_255037_(registries, pStructureState, pStructureManager, pChunk, pStructureTemplateManager);
        }
    }

    private boolean hasStructures(RegistryAccess registries) {
        return registries.m_175515_(Registries.f_256998_).m_206058_(this.allowedStructureSets).iterator().hasNext();
    }

    private static class FilteredLookup
    extends HolderLookup.Delegate<StructureSet> {
        private final TagKey<StructureSet> allowedValues;

        private FilteredLookup(HolderLookup<StructureSet> pParent, TagKey<StructureSet> allowedValues) {
            super(pParent);
            this.allowedValues = allowedValues;
        }

        public Optional<Holder.Reference<StructureSet>> m_254902_(ResourceKey<StructureSet> key) {
            return this.f_254653_.m_254902_(key).filter(obj -> obj.m_203656_(this.allowedValues));
        }

        public Stream<Holder.Reference<StructureSet>> m_214062_() {
            return this.f_254653_.m_214062_().filter(obj -> obj.m_203656_(this.allowedValues));
        }
    }
}

