/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.transformer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.sinytra.adapter.patch.PatchInstance;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.api.MethodTransform;
import org.sinytra.adapter.patch.api.Patch;
import org.sinytra.adapter.patch.api.PatchContext;
import org.slf4j.Logger;

public record ModifyMethodAccess(List<AccessChange> changes) implements MethodTransform
{
    public static final Codec<ModifyMethodAccess> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)AccessChange.CODEC.listOf().fieldOf("changes").forGetter(ModifyMethodAccess::changes)).apply((Applicative)instance, ModifyMethodAccess::new));
    private static final Logger LOGGER = LogUtils.getLogger();

    @Override
    public Codec<? extends MethodTransform> codec() {
        return CODEC;
    }

    @Override
    public Patch.Result apply(ClassNode classNode, MethodNode methodNode, MethodContext methodContext, PatchContext context) {
        Patch.Result result = Patch.Result.PASS;
        for (AccessChange change : this.changes) {
            if (change.add) {
                if ((methodNode.access & change.modifier) != 0) continue;
                LOGGER.info(PatchInstance.MIXINPATCH, "Adding access modifier {} to method {}.{}{}", new Object[]{change.modifier, classNode.name, methodNode.name, methodNode.desc});
                methodNode.access |= change.modifier;
                result = Patch.Result.APPLY;
                if (change.modifier != 8 || !methodContext.methodAnnotation().matchesDesc("Lorg/spongepowered/asm/mixin/injection/Inject;")) continue;
                List<Type> types = methodContext.targetTypes();
                if (types.size() == 1) {
                    Type[] params = Type.getArgumentTypes((String)methodNode.desc);
                    ArrayList<Type> newParams = new ArrayList<Type>(Arrays.asList(params));
                    newParams.add(0, types.get(0));
                    methodContext.updateDescription(newParams);
                    continue;
                }
                throw new IllegalStateException("Cannot automatically determine target instance type for mixin " + classNode.name);
            }
            if ((methodNode.access & change.modifier) == 0) continue;
            LOGGER.info(PatchInstance.MIXINPATCH, "Removing access modifier {} from method {}.{}{}", new Object[]{change.modifier, classNode.name, methodNode.name, methodNode.desc});
            methodNode.access &= ~change.modifier;
            if (change.modifier == 8) {
                LocalVariableNode firstParam = methodNode.localVariables.stream().filter(lvn -> lvn.index == 0).findFirst().orElseThrow();
                for (LocalVariableNode lvn2 : methodNode.localVariables) {
                    ++lvn2.index;
                }
                for (AbstractInsnNode insn : methodNode.instructions) {
                    if (!(insn instanceof VarInsnNode)) continue;
                    VarInsnNode varInsn = (VarInsnNode)insn;
                    ++varInsn.var;
                }
                methodNode.localVariables.add(new LocalVariableNode("this", Type.getObjectType((String)classNode.name).getDescriptor(), null, firstParam.start, firstParam.end, 0));
                result = Patch.Result.COMPUTE_FRAMES;
                continue;
            }
            result = Patch.Result.APPLY;
        }
        return result;
    }

    public record AccessChange(boolean add, int modifier) {
        public static final Codec<AccessChange> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("add").forGetter(AccessChange::add), (App)Codec.INT.fieldOf("modifier").forGetter(AccessChange::modifier)).apply((Applicative)instance, AccessChange::new));
    }
}

