/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.connector.transformer;

import com.google.common.collect.ImmutableMap;
import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import net.minecraftforge.coremod.api.ASMAPI;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.sinytra.adapter.patch.api.Patch;
import org.sinytra.connector.transformer.patch.ClassNodeTransformer;
import org.slf4j.Logger;
import reloc.net.fabricmc.accesswidener.AccessWidenerReader;
import reloc.net.fabricmc.accesswidener.AccessWidenerVisitor;
import reloc.net.fabricmc.accesswidener.AccessWidenerWriter;
import reloc.net.fabricmc.accesswidener.ForwardingVisitor;
import reloc.net.minecraftforge.fart.api.Transformer;
import reloc.net.minecraftforge.srgutils.IMappingFile;

public class FieldToMethodTransformer
implements ClassNodeTransformer.ClassProcessor {
    public static final Map<String, Map<String, String>> REPLACEMENTS = ImmutableMap.builder().put((Object)"net.minecraft.world.level.biome.Biome", Map.of("f_47437_", "getModifiedClimateSettings", "f_47443_", "getModifiedSpecialEffects")).put((Object)"net.minecraft.world.level.levelgen.structure.Structure", Map.of("f_226555_", "getModifiedStructureSettings")).put((Object)"net.minecraft.world.effect.MobEffectInstance", Map.of("f_19502_", "m_19544_")).put((Object)"net.minecraft.world.level.block.LiquidBlock", Map.of("f_54689_", "getFluid")).put((Object)"net.minecraft.world.item.BucketItem", Map.of("f_40687_", "getFluid")).put((Object)"net.minecraft.world.level.block.StairBlock", Map.of("f_56858_", "getModelBlock", "f_56859_", "getModelState")).put((Object)"net.minecraft.world.level.block.FlowerPotBlock", Map.of("f_53525_", "m_53560_")).put((Object)"net.minecraft.world.item.ItemStack", Map.of("f_41589_", "m_41720_")).put((Object)"net.minecraft.world.item.MobBucketItem", Map.of("f_151134_", "getFishType", "f_151135_", "getEmptySound")).put((Object)"net.minecraft.client.particle.ParticleEngine", Map.of("f_107293_", "connector$getProviders")).put((Object)"net.minecraft.client.color.block.BlockColors", Map.of("f_92571_", "connector$getBlockColors")).put((Object)"net.minecraft.client.color.item.ItemColors", Map.of("f_92674_", "connector$getItemColors")).buildOrThrow();
    private static final Logger LOGGER = LogUtils.getLogger();
    private final String accessWidenerResource;
    private final Map<String, String> mappedReplacements;

    public FieldToMethodTransformer(String accessWidenerResource, IMappingFile mappings) {
        this.accessWidenerResource = accessWidenerResource;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        REPLACEMENTS.forEach((cls, replacements) -> {
            IMappingFile.IClass classMap = Objects.requireNonNull(mappings.getClass(cls.replace('.', '/')));
            replacements.forEach((field, getter) -> builder.put((Object)classMap.remapField((String)field), (Object)ASMAPI.mapMethod((String)getter)));
        });
        this.mappedReplacements = builder.build();
    }

    @Override
    public Patch.Result process(ClassNode node) {
        return this.processClass(node) ? Patch.Result.APPLY : Patch.Result.PASS;
    }

    @Override
    public Transformer.ResourceEntry process(Transformer.ResourceEntry entry) {
        if (entry.getName().equals(this.accessWidenerResource)) {
            AccessWidenerWriter writer = new AccessWidenerWriter();
            FilteringAccessWidenerVisitor filter = new FilteringAccessWidenerVisitor(this.mappedReplacements.keySet(), writer);
            AccessWidenerReader reader = new AccessWidenerReader(filter);
            reader.read(entry.getData());
            return Transformer.ResourceEntry.create(entry.getName(), entry.getTime(), writer.write());
        }
        return entry;
    }

    private boolean processClass(ClassNode cls) {
        boolean replaced = false;
        for (MethodNode method : cls.methods) {
            ListIterator iterator = method.instructions.iterator();
            while (iterator.hasNext()) {
                FieldInsnNode fieldInsn;
                AbstractInsnNode insn = (AbstractInsnNode)iterator.next();
                if (!(insn instanceof FieldInsnNode) || (fieldInsn = (FieldInsnNode)insn).getOpcode() != 180 && fieldInsn.getOpcode() != 178) continue;
                for (Map.Entry<String, String> entry : this.mappedReplacements.entrySet()) {
                    String source = entry.getKey();
                    if (!source.equals(fieldInsn.name)) continue;
                    LOGGER.trace("Replacing field getter {} to method {} in {}#{}", new Object[]{source, entry.getValue(), cls.name, method.name});
                    iterator.remove();
                    String getterDesc = "()" + fieldInsn.desc;
                    MethodInsnNode getterCall = new MethodInsnNode(182, fieldInsn.owner, entry.getValue(), getterDesc, false);
                    iterator.add(getterCall);
                    replaced = true;
                }
            }
        }
        return replaced;
    }

    private static class FilteringAccessWidenerVisitor
    extends ForwardingVisitor {
        private final Collection<String> exclude;

        public FilteringAccessWidenerVisitor(Collection<String> exclude, AccessWidenerVisitor ... visitors) {
            super(visitors);
            this.exclude = exclude;
        }

        @Override
        public void visitMethod(String owner, String name, String descriptor, AccessWidenerReader.AccessType access, boolean transitive) {
            if (!this.exclude.contains(name)) {
                super.visitMethod(owner, name, descriptor, access, transitive);
            }
        }

        @Override
        public void visitField(String owner, String name, String descriptor, AccessWidenerReader.AccessType access, boolean transitive) {
            if (!this.exclude.contains(name)) {
                super.visitField(owner, name, descriptor, access, transitive);
            }
        }
    }
}

