/*
 * Decompiled with CFR 0.152.
 */
package reloc.net.fabricmc.accesswidener;

import org.objectweb.asm.commons.Remapper;
import reloc.net.fabricmc.accesswidener.AccessWidenerReader;
import reloc.net.fabricmc.accesswidener.AccessWidenerVisitor;

public final class AccessWidenerRemapper
implements AccessWidenerVisitor {
    private final AccessWidenerVisitor delegate;
    private final String fromNamespace;
    private final String toNamespace;
    private final Remapper remapper;

    public AccessWidenerRemapper(AccessWidenerVisitor delegate, Remapper remapper, String fromNamespace, String toNamespace) {
        this.delegate = delegate;
        this.fromNamespace = fromNamespace;
        this.toNamespace = toNamespace;
        this.remapper = remapper;
    }

    @Override
    public void visitHeader(String namespace) {
        if (!this.fromNamespace.equals(namespace)) {
            throw new IllegalArgumentException("Cannot remap access widener from namespace '" + namespace + "'. Expected: '" + this.fromNamespace + "'");
        }
        this.delegate.visitHeader(this.toNamespace);
    }

    @Override
    public void visitClass(String name, AccessWidenerReader.AccessType access, boolean transitive) {
        this.delegate.visitClass(this.remapper.map(name), access, transitive);
    }

    @Override
    public void visitMethod(String owner, String name, String descriptor, AccessWidenerReader.AccessType access, boolean transitive) {
        this.delegate.visitMethod(this.remapper.map(owner), this.remapper.mapMethodName(owner, name, descriptor), this.remapper.mapDesc(descriptor), access, transitive);
    }

    @Override
    public void visitField(String owner, String name, String descriptor, AccessWidenerReader.AccessType access, boolean transitive) {
        this.delegate.visitField(this.remapper.map(owner), this.remapper.mapFieldName(owner, name, descriptor), this.remapper.mapDesc(descriptor), access, transitive);
    }
}

