/*
 * Decompiled with CFR 0.152.
 */
package reloc.net.minecraftforge.fart.internal;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import reloc.net.minecraftforge.fart.api.ClassProvider;
import reloc.net.minecraftforge.fart.internal.ClassProviderImpl;

public class ClassProviderBuilderImpl
implements ClassProvider.Builder {
    private final List<FileSystem> fileSystems = new ArrayList<FileSystem>();
    private final Map<String, Path> sources = new HashMap<String, Path>();
    private final Map<String, Optional<? extends ClassProvider.IClassInfo>> classInfos = new ConcurrentHashMap<String, Optional<? extends ClassProvider.IClassInfo>>();
    private boolean cacheAll = false;

    @Override
    public ClassProvider.Builder addLibrary(Path path) {
        try {
            Path libraryDir;
            if (Files.isDirectory(path, new LinkOption[0])) {
                libraryDir = path;
            } else if (Files.isRegularFile(path, new LinkOption[0])) {
                FileSystem zipFs = FileSystems.newFileSystem(path, (ClassLoader)null);
                this.fileSystems.add(zipFs);
                libraryDir = zipFs.getPath("/", new String[0]);
            } else {
                return this;
            }
            try (Stream<Path> walker = Files.walk(libraryDir, new FileVisitOption[0]);){
                walker.forEach(fullPath -> {
                    Path relativePath = libraryDir.relativize((Path)fullPath);
                    String pathName = relativePath.toString().replace('\\', '/');
                    if (!pathName.endsWith(".class") || pathName.startsWith("META-INF")) {
                        return;
                    }
                    this.sources.putIfAbsent(pathName.substring(0, pathName.length() - 6), (Path)fullPath);
                });
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not add library: " + path.toAbsolutePath(), e);
        }
        return this;
    }

    @Override
    public ClassProvider.Builder addClass(String name, byte[] value) {
        this.classInfos.computeIfAbsent(name, k -> Optional.of(new ClassProviderImpl.ClassInfo(value)));
        return this;
    }

    @Override
    public ClassProvider.Builder shouldCacheAll(boolean value) {
        this.cacheAll = value;
        return this;
    }

    @Override
    public ClassProvider build() {
        return new ClassProviderImpl(this.fileSystems, this.sources, this.classInfos, this.cacheAll);
    }
}

