/*
 * Decompiled with CFR 0.152.
 */
package reloc.org.sat4j.pb;

import java.math.BigInteger;
import reloc.org.sat4j.core.VecInt;
import reloc.org.sat4j.pb.IPBSolver;
import reloc.org.sat4j.pb.ObjectiveFunction;
import reloc.org.sat4j.pb.PBSolverDecorator;
import reloc.org.sat4j.specs.ContradictionException;
import reloc.org.sat4j.specs.IConstr;
import reloc.org.sat4j.specs.IOptimizationProblem;
import reloc.org.sat4j.specs.ISolver;
import reloc.org.sat4j.specs.IVecInt;
import reloc.org.sat4j.specs.RandomAccessModel;
import reloc.org.sat4j.specs.TimeoutException;

public class PseudoOptDecorator
extends PBSolverDecorator
implements IOptimizationProblem {
    private static final long serialVersionUID = 1L;
    protected BigInteger objectiveValue;
    private int[] prevmodel;
    private int[] prevmodelwithadditionalvars;
    private boolean[] prevfullmodel;
    private IVecInt prevModelBlockingClause;
    private IConstr previousPBConstr;
    private boolean isSolutionOptimal;
    private final boolean nonOptimalMeansSatisfiable;
    private final boolean useAnImplicantForEvaluation;
    private int solverTimeout = Integer.MAX_VALUE;
    private int optimizationTimeout = -1;

    public PseudoOptDecorator(IPBSolver solver) {
        this(solver, true);
    }

    public PseudoOptDecorator(IPBSolver solver, boolean nonOptimalMeansSatisfiable) {
        this(solver, nonOptimalMeansSatisfiable, false);
    }

    public PseudoOptDecorator(IPBSolver solver, boolean nonOptimalMeansSatisfiable, boolean useAnImplicantForEvaluation) {
        super(solver);
        this.nonOptimalMeansSatisfiable = nonOptimalMeansSatisfiable;
        this.useAnImplicantForEvaluation = useAnImplicantForEvaluation;
    }

    @Override
    public boolean isSatisfiable() throws TimeoutException {
        return this.isSatisfiable(VecInt.EMPTY);
    }

    @Override
    public boolean isSatisfiable(boolean global) throws TimeoutException {
        return this.isSatisfiable(VecInt.EMPTY, global);
    }

    @Override
    public boolean isSatisfiable(IVecInt assumps, boolean global) throws TimeoutException {
        boolean result = super.isSatisfiable(assumps, global);
        if (result) {
            this.prevmodel = super.model();
            this.prevModelBlockingClause = super.createBlockingClauseForCurrentModel();
            this.prevmodelwithadditionalvars = super.modelWithInternalVariables();
            this.prevfullmodel = new boolean[this.nVars()];
            for (int i = 0; i < this.nVars(); ++i) {
                this.prevfullmodel[i] = ((IPBSolver)this.decorated()).model(i + 1);
            }
            if (this.optimizationTimeout > 0) {
                super.expireTimeout();
                super.setTimeout(this.optimizationTimeout);
            }
        } else {
            if (this.previousPBConstr != null) {
                ((IPBSolver)this.decorated()).removeConstr(this.previousPBConstr);
                this.previousPBConstr = null;
            }
            super.setTimeout(this.solverTimeout);
        }
        return result;
    }

    @Override
    public boolean isSatisfiable(IVecInt assumps) throws TimeoutException {
        return this.isSatisfiable(assumps, false);
    }

    @Override
    public void setObjectiveFunction(ObjectiveFunction objf) {
        ((IPBSolver)this.decorated()).setObjectiveFunction(objf);
    }

    @Override
    public boolean admitABetterSolution() throws TimeoutException {
        return this.admitABetterSolution(VecInt.EMPTY);
    }

    @Override
    public boolean admitABetterSolution(IVecInt assumps) throws TimeoutException {
        try {
            this.isSolutionOptimal = false;
            boolean result = super.isSatisfiable(assumps, true);
            if (result) {
                this.prevmodel = this.useAnImplicantForEvaluation ? this.modelWithAdaptedNonPrimeLiterals() : super.model();
                this.prevModelBlockingClause = super.createBlockingClauseForCurrentModel();
                this.prevmodelwithadditionalvars = super.modelWithInternalVariables();
                this.prevfullmodel = new boolean[this.nVars()];
                for (int i = 0; i < this.nVars(); ++i) {
                    this.prevfullmodel[i] = ((IPBSolver)this.decorated()).model(i + 1);
                }
                if (((IPBSolver)this.decorated()).getObjectiveFunction() != null) {
                    this.calculateObjective();
                }
                if (this.optimizationTimeout > 0) {
                    super.expireTimeout();
                    super.setTimeout(this.optimizationTimeout);
                }
            } else {
                this.isSolutionOptimal = true;
                if (this.previousPBConstr != null) {
                    ((IPBSolver)this.decorated()).removeConstr(this.previousPBConstr);
                    this.previousPBConstr = null;
                }
            }
            return result;
        }
        catch (TimeoutException te) {
            if (this.previousPBConstr != null) {
                ((IPBSolver)this.decorated()).removeConstr(this.previousPBConstr);
                this.previousPBConstr = null;
            }
            throw te;
        }
    }

    private int[] modelWithAdaptedNonPrimeLiterals() {
        int[] completeModel = new int[this.nVars()];
        for (int i = 0; i < this.nVars(); ++i) {
            int var = i + 1;
            completeModel[i] = super.model(var) ? var : -var;
        }
        this.primeImplicant();
        ObjectiveFunction obj = this.getObjectiveFunction();
        for (int i = 0; i < obj.getVars().size(); ++i) {
            int d = obj.getVars().get(i);
            BigInteger coeff = obj.getCoeffs().get(i);
            if (d > this.nVars() || this.primeImplicant(d) || this.primeImplicant(-d)) continue;
            assert (Math.abs(completeModel[Math.abs(d) - 1]) == d);
            completeModel[Math.abs((int)d) - 1] = coeff.signum() * d < 0 ? Math.abs(d) : -Math.abs(d);
        }
        return completeModel;
    }

    @Override
    public boolean hasNoObjectiveFunction() {
        return ((IPBSolver)this.decorated()).getObjectiveFunction() == null;
    }

    @Override
    public boolean nonOptimalMeansSatisfiable() {
        return this.nonOptimalMeansSatisfiable;
    }

    @Override
    public Number calculateObjective() {
        if (((IPBSolver)this.decorated()).getObjectiveFunction() == null) {
            throw new UnsupportedOperationException("The problem does not contain an objective function");
        }
        this.objectiveValue = this.useAnImplicantForEvaluation ? ((IPBSolver)this.decorated()).getObjectiveFunction().calculateDegreeImplicant((ISolver)this.decorated()) : ((IPBSolver)this.decorated()).getObjectiveFunction().calculateDegree((RandomAccessModel)this.decorated());
        return this.getObjectiveValue();
    }

    @Override
    public void discardCurrentSolution() throws ContradictionException {
        if (this.previousPBConstr != null) {
            super.removeSubsumedConstr(this.previousPBConstr);
        }
        if (((IPBSolver)this.decorated()).getObjectiveFunction() != null && this.objectiveValue != null) {
            this.previousPBConstr = super.addPseudoBoolean(((IPBSolver)this.decorated()).getObjectiveFunction().getVars(), ((IPBSolver)this.decorated()).getObjectiveFunction().getCoeffs(), false, this.objectiveValue.subtract(BigInteger.ONE));
        }
    }

    @Override
    public void reset() {
        this.previousPBConstr = null;
        super.reset();
    }

    @Override
    public int[] model() {
        if (this.prevmodel.length <= this.nVars()) {
            return this.prevmodel;
        }
        throw new RuntimeException("New variables have been added since the last model found");
    }

    @Override
    public boolean model(int var) {
        return this.prevfullmodel[var - 1];
    }

    @Override
    public String toString(String prefix) {
        return prefix + "Pseudo Boolean Optimization by upper bound\n" + (this.useAnImplicantForEvaluation ? prefix + "using prime implicants for evaluating the objective function\n" : "") + super.toString(prefix);
    }

    @Override
    public Number getObjectiveValue() {
        BigInteger offset = ((IPBSolver)this.decorated()).getObjectiveFunction().getCorrectionOffset();
        BigInteger factor = ((IPBSolver)this.decorated()).getObjectiveFunction().getCorrectionFactor();
        return this.objectiveValue.multiply(factor).add(offset);
    }

    @Override
    public void discard() throws ContradictionException {
        this.discardCurrentSolution();
    }

    @Override
    public void forceObjectiveValueTo(Number forcedValue) throws ContradictionException {
        super.addPseudoBoolean(((IPBSolver)this.decorated()).getObjectiveFunction().getVars(), ((IPBSolver)this.decorated()).getObjectiveFunction().getCoeffs(), false, (BigInteger)forcedValue);
    }

    @Override
    public boolean isOptimal() {
        return this.isSolutionOptimal;
    }

    @Override
    public int[] modelWithInternalVariables() {
        return this.prevmodelwithadditionalvars;
    }

    @Override
    public void setTimeoutForFindingBetterSolution(int seconds) {
        this.optimizationTimeout = seconds;
    }

    @Override
    public void setTimeout(int t) {
        this.solverTimeout = t;
        super.setTimeout(t);
    }

    public void removeSubsumedOptConstr() {
        if (this.previousPBConstr == null) {
            return;
        }
        super.removeSubsumedConstr(this.previousPBConstr);
        this.previousPBConstr = null;
    }

    @Override
    public IConstr discardCurrentModel() throws ContradictionException {
        return this.addBlockingClause(this.prevModelBlockingClause);
    }
}

