/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.pneumatic_armor.options;

import java.util.Collections;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IGuiScreen;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IOptionPage;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.pneumatic_armor.upgrade_handler.CoordTrackClientHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.ArmorMessage;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;

public class CoordinateTrackerOptions
extends IOptionPage.SimpleOptionPage<CoordTrackClientHandler> {
    private Button wirePath;
    private Button pathEnabled;
    private Button xRayEnabled;
    private Button pathUpdateRate;
    private final CoordTrackClientHandler coordHandler = (CoordTrackClientHandler)this.getClientUpgradeHandler();
    private final Minecraft mc = Minecraft.m_91087_();

    public CoordinateTrackerOptions(IGuiScreen screen, CoordTrackClientHandler clientHandler) {
        super(screen, clientHandler);
    }

    @Override
    public void populateGui(IGuiScreen gui) {
        gui.addWidget(new WidgetButtonExtended(30, 40, 150, 20, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.gui.coordinateTracker.selectTarget", new Object[0]), b -> this.selectTarget()));
        gui.addWidget(new WidgetButtonExtended(30, 62, 150, 20, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.gui.coordinateTracker.navigateToSurface", new Object[0]), b -> this.navigateToSurface()));
        this.pathEnabled = new WidgetButtonExtended(30, 128, 150, 20, (Component)Component.m_237119_(), b -> {
            this.coordHandler.pathEnabled = !this.coordHandler.pathEnabled;
            this.updateButtonTexts();
            this.coordHandler.saveToConfig();
        });
        this.wirePath = new WidgetButtonExtended(30, 150, 150, 20, (Component)Component.m_237119_(), b -> {
            this.coordHandler.wirePath = !this.coordHandler.wirePath;
            this.updateButtonTexts();
            this.coordHandler.saveToConfig();
        });
        this.xRayEnabled = new WidgetButtonExtended(30, 172, 150, 20, (Component)Component.m_237119_(), b -> {
            this.coordHandler.xRayEnabled = !this.coordHandler.xRayEnabled;
            this.updateButtonTexts();
            this.coordHandler.saveToConfig();
        });
        this.pathUpdateRate = new WidgetButtonExtended(30, 194, 150, 20, (Component)Component.m_237119_(), b -> {
            this.coordHandler.pathUpdateSetting = this.coordHandler.pathUpdateSetting.cycle();
            this.updateButtonTexts();
            this.coordHandler.saveToConfig();
        });
        gui.addWidget(this.pathEnabled);
        gui.addWidget(this.wirePath);
        gui.addWidget(this.xRayEnabled);
        gui.addWidget(this.pathUpdateRate);
        this.updateButtonTexts();
    }

    private void selectTarget() {
        ClientUtils.getClientPlayer().m_6915_();
        this.mc.m_7440_(true);
        this.coordHandler.isListeningToCoordTrackerSetting = true;
        HUDHandler.getInstance().addMessage((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.message.coordinateTracker.settingCoord", new Object[0]), Collections.singletonList(PneumaticCraftUtils.xlate("pneumaticcraft.armor.message.coordinateTracker.rightClickToSet", new Object[0])), 90, 0x7000AA00);
    }

    private void navigateToSurface() {
        ClientUtils.getClientPlayer().m_6915_();
        this.mc.m_7440_(true);
        switch (this.coordHandler.navigateToSurface(ClientUtils.getClientPlayer())) {
            case EASY_PATH: {
                HUDHandler.getInstance().addMessage(new ArmorMessage((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.message.coordinateTracker.routeFound", new Object[0]), 90, 0x7000AA00));
                break;
            }
            case DRONE_PATH: {
                HUDHandler.getInstance().addMessage(new ArmorMessage((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.message.coordinateTracker.harderRouteFound", new Object[0]), 90, 1883548160));
                break;
            }
            case NO_PATH: {
                HUDHandler.getInstance().addMessage(new ArmorMessage((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.message.coordinateTracker.noRouteFound", new Object[0]), 90, 0x70FF0000));
            }
        }
    }

    private void updateButtonTexts() {
        this.pathEnabled.m_93666_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.gui.coordinateTracker.navEnabled." + this.coordHandler.pathEnabled, new Object[0]));
        this.wirePath.m_93666_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.gui.coordinateTracker.wirePath." + this.coordHandler.wirePath, new Object[0]));
        this.xRayEnabled.m_93666_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.gui.coordinateTracker.xray." + this.coordHandler.xRayEnabled, new Object[0]));
        this.pathUpdateRate.m_93666_((Component)PneumaticCraftUtils.xlate(this.coordHandler.pathUpdateSetting.getTranslationKey(), new Object[0]));
        this.wirePath.f_93623_ = this.coordHandler.pathEnabled;
        this.xRayEnabled.f_93623_ = this.coordHandler.pathEnabled;
        this.pathUpdateRate.f_93623_ = this.coordHandler.pathEnabled;
    }

    @Override
    public boolean displaySettingsHeader() {
        return true;
    }
}

