/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.client.gui.widget.IDrawAfterRender;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.common.util.ITranslatableEnum;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;

public class WidgetComboBox
extends WidgetTextField
implements IDrawAfterRender {
    private final ArrayList<String> elements = new ArrayList();
    private final Font fontRenderer;
    private boolean enabled = true;
    private boolean fixedOptions;
    private boolean shouldSort = true;
    private int selectedIndex = -1;
    private final int baseHeight;
    private final Consumer<WidgetComboBox> pressable;
    private List<String> applicable = null;
    private boolean expanded = false;

    public WidgetComboBox(Font fontRenderer, int x, int y, int width, int height) {
        this(fontRenderer, x, y, width, height, b -> {});
    }

    public WidgetComboBox(Font fontRenderer, int x, int y, int width, int height, Consumer<WidgetComboBox> pressable) {
        super(fontRenderer, x, y, width, height);
        this.fontRenderer = fontRenderer;
        this.baseHeight = height;
        this.pressable = pressable;
        this.m_94205_(0xE0E0E0);
    }

    public WidgetComboBox setElements(Collection<String> elements) {
        this.elements.clear();
        this.elements.addAll(elements);
        if (this.shouldSort) {
            Collections.sort(this.elements);
        }
        return this;
    }

    public WidgetComboBox setElements(String[] elements) {
        this.elements.clear();
        this.elements.ensureCapacity(elements.length);
        this.elements.addAll(Arrays.asList(elements));
        if (this.shouldSort) {
            Collections.sort(this.elements);
        }
        return this;
    }

    public WidgetComboBox setShouldSort(boolean shouldSort) {
        this.shouldSort = shouldSort;
        return this;
    }

    private List<String> getApplicableElements() {
        this.applicable = this.elements.stream().filter(element -> this.fixedOptions || element.toLowerCase().contains(this.m_94155_().toLowerCase())).collect(Collectors.toList());
        return this.applicable;
    }

    public void m_94164_(String textToWrite) {
        super.m_94164_(textToWrite);
        this.applicable = null;
    }

    @Override
    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.m_87963_(graphics, mouseX, mouseY, partialTick);
        graphics.m_280056_(this.fontRenderer, this.expanded ? "\u25b2" : "\u25bc", this.m_252754_() + this.f_93618_ - 7, this.m_252907_() + 1, 0xC0C0C0, false);
    }

    @Override
    public void renderAfterEverythingElse(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.enabled && this.f_93623_ && this.expanded) {
            int x = this.m_252754_();
            int y = this.m_252907_();
            List<String> applicableElements = this.getApplicableElements();
            int n = applicableElements.size();
            Objects.requireNonNull(this.fontRenderer);
            graphics.m_280509_(x - 1, y + this.f_93619_ + 1, x + this.f_93618_ + 1, y + this.f_93619_ + 3 + n * 9, -6250336);
            int n2 = applicableElements.size();
            Objects.requireNonNull(this.fontRenderer);
            graphics.m_280509_(x, y + this.f_93619_ + 1, x + this.f_93618_, y + this.f_93619_ + 2 + n2 * 9, -16777216);
            Objects.requireNonNull(this.fontRenderer);
            int hovered = (mouseY - y - this.f_93619_) / 9;
            for (int i = 0; i < applicableElements.size(); ++i) {
                String element = applicableElements.get(i);
                String string = this.fontRenderer.m_92834_(element, this.m_5711_());
                Objects.requireNonNull(this.fontRenderer);
                graphics.m_280488_(this.fontRenderer, string, x + 4, y + this.f_93619_ + 2 + i * 9, i == hovered ? 16769152 : 0xE0E0E0);
            }
        }
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.m_94213_() && this.f_93623_ && button == 0) {
            boolean flag;
            int n;
            int x = this.m_252754_();
            int y = this.m_252907_();
            if (this.expanded) {
                int n2 = this.getApplicableElements().size();
                Objects.requireNonNull(this.fontRenderer);
                n = n2 * 9;
            } else {
                n = 0;
            }
            int h = this.baseHeight + n;
            boolean bl = flag = mouseX >= (double)x && mouseX < (double)(x + this.f_93618_) && mouseY >= (double)y && mouseY < (double)(y + h);
            if (flag) {
                if (mouseY < (double)(y + this.f_93619_)) {
                    this.expanded = !this.expanded;
                } else {
                    this.expanded = false;
                    int n3 = (int)mouseY - y - this.f_93619_;
                    Objects.requireNonNull(this.fontRenderer);
                    int i = n3 / 9;
                    if (i < this.getApplicableElements().size()) {
                        this.m_94144_(this.getApplicableElements().get(i));
                        this.selectedIndex = i;
                        this.pressable.accept(this);
                    }
                }
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        List<String> applicableElements;
        if (this.fixedOptions) {
            return false;
        }
        if (this.enabled && this.expanded && keyCode == 258 && (applicableElements = this.getApplicableElements()).size() > 0) {
            this.m_94144_(applicableElements.get(0));
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char key, int keyCode) {
        return !this.fixedOptions && super.m_5534_(key, keyCode);
    }

    public void m_94186_(boolean enabled) {
        super.m_94186_(enabled);
        this.enabled = enabled;
    }

    public WidgetComboBox setFixedOptions(boolean fixed) {
        this.fixedOptions = fixed;
        super.m_94186_(!fixed);
        this.applicable = null;
        return this;
    }

    public int getSelectedElementIndex() {
        return this.selectedIndex;
    }

    public void selectElement(int index) {
        if (index >= 0 && index < this.elements.size()) {
            this.selectedIndex = index;
            this.m_94144_(this.elements.get(index));
        }
    }

    public final <T extends Enum<T>> WidgetComboBox initFromEnum(T initialValue, Function<T, String> xlate) {
        List<String> labels = Arrays.stream((Enum[])initialValue.getClass().getEnumConstants()).filter(val -> initialValue.getClass().isAssignableFrom(val.getClass())).map(val -> val).map(xlate).collect(Collectors.toList());
        this.setShouldSort(false);
        this.setElements(labels);
        this.setFixedOptions(true);
        this.selectElement(initialValue.ordinal());
        return this;
    }

    public final <T extends Enum<T>> WidgetComboBox initFromEnum(T initialValue) {
        if (initialValue instanceof ITranslatableEnum) {
            return this.initFromEnum(initialValue, e -> I18n.m_118938_((String)((ITranslatableEnum)((Object)e)).getTranslationKey(), (Object[])new Object[0]));
        }
        throw new IllegalArgumentException(String.valueOf(initialValue) + " must implement ITranslatableEnum!");
    }
}

