/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.thirdparty.ModNameCache;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class WidgetTank
extends AbstractWidget {
    private final IFluidTank tank;

    public WidgetTank(int x, int y, IFluidTank tank) {
        super(x, y, 16, 64, (Component)Component.m_237119_());
        this.tank = tank;
    }

    public WidgetTank(int x, int y, FluidStack stack) {
        this(x, y, (IFluidTank)WidgetTank.makeTank(stack, 160000));
    }

    public WidgetTank(int x, int y, int width, int height, FluidStack stack) {
        super(x, y, width, height, (Component)Component.m_237119_());
        this.tank = WidgetTank.makeTank(stack, stack.getAmount());
    }

    public WidgetTank(int x, int y, int width, int height, FluidStack stack, int capacity) {
        super(x, y, width, height, (Component)Component.m_237119_());
        this.tank = WidgetTank.makeTank(stack, capacity);
    }

    private static FluidTank makeTank(FluidStack stack, int capacity) {
        FluidTank tank = new FluidTank(capacity);
        tank.fill(stack, IFluidHandler.FluidAction.EXECUTE);
        return tank;
    }

    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int x = this.m_252754_();
        int y = this.m_252907_();
        GuiUtils.drawFluid(graphics, new Rect2i(x, y, this.f_93618_, this.f_93619_), this.getFluid(), this.getTank());
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 300.0f);
        for (int i = 3; i < this.f_93619_ - 1; i += 4) {
            int width = (i - 3) % 20 == 0 ? 16 : 2;
            graphics.m_280509_(x, y + i, x + width, y + i + 1, -13684945);
        }
        graphics.m_280168_().m_85849_();
        this.m_257544_(Tooltip.m_257550_((Component)PneumaticCraftUtils.combineComponents(this.makeTooltip())));
    }

    public List<Component> makeTooltip() {
        Fluid fluid = this.tank.getFluid().getFluid();
        String amt = NumberFormat.getNumberInstance(Locale.getDefault()).format(this.tank.getFluidAmount());
        String capacity = NumberFormat.getNumberInstance(Locale.getDefault()).format(this.tank.getCapacity());
        ArrayList<Component> l = new ArrayList<Component>();
        l.add((Component)Component.m_237113_((String)(amt + " / " + capacity + " mB")));
        if (fluid == Fluids.f_76191_ || this.tank.getCapacity() == 0 || this.tank.getFluidAmount() == 0) {
            l.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.empty", new Object[0]).m_130940_(ChatFormatting.GRAY));
        } else {
            l.add((Component)new FluidStack(fluid, this.tank.getFluidAmount()).getDisplayName().m_6881_().m_130940_(ChatFormatting.GRAY));
            l.add((Component)Component.m_237113_((String)ModNameCache.getModName(fluid)).m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC}));
        }
        return l;
    }

    public FluidStack getFluid() {
        return this.tank.getFluid();
    }

    public IFluidTank getTank() {
        return this.tank;
    }

    public void setFluid(FluidStack fluidStack) {
        if (fluidStack.getFluid() != this.tank.getFluid().getFluid()) {
            this.tank.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
            this.tank.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
        } else if (fluidStack.getAmount() > this.tank.getFluidAmount()) {
            this.tank.fill(new FluidStack(fluidStack.getFluid(), fluidStack.getAmount() - this.tank.getFluidAmount()), IFluidHandler.FluidAction.EXECUTE);
        } else if (fluidStack.getAmount() < this.tank.getFluidAmount()) {
            this.tank.drain(this.tank.getFluidAmount() - fluidStack.getAmount(), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public void m_168797_(NarrationElementOutput pNarrationElementOutput) {
    }
}

