/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.model.custom;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.common.block.AbstractCamouflageBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import org.jetbrains.annotations.NotNull;

public class CamouflageModel
implements IDynamicBakedModel {
    private final BakedModel originalModel;

    private CamouflageModel(BakedModel originalModel) {
        this.originalModel = originalModel;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData modelData, RenderType renderType) {
        if (state == null || !(state.m_60734_() instanceof AbstractCamouflageBlock)) {
            return this.originalModel.getQuads(state, side, rand, modelData, renderType);
        }
        BlockState camoState = (BlockState)modelData.get(AbstractCamouflageBlock.CAMO_STATE);
        if (renderType == null) {
            renderType = RenderType.m_110451_();
        }
        if (camoState == null && renderType == RenderType.m_110451_()) {
            return this.originalModel.getQuads(state, side, rand, modelData, renderType);
        }
        if (camoState != null && this.getRenderTypes(camoState, rand, modelData).contains(renderType)) {
            BakedModel model = Minecraft.m_91087_().m_91289_().m_110907_().m_110893_(camoState);
            return model.getQuads(camoState, side, rand, modelData, renderType);
        }
        return Collections.emptyList();
    }

    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        BlockState camoState = (BlockState)data.get(AbstractCamouflageBlock.CAMO_STATE);
        return super.getRenderTypes(camoState == null ? state : camoState, rand, data);
    }

    public boolean m_7541_() {
        return this.originalModel.m_7541_();
    }

    public boolean m_7539_() {
        return this.originalModel.m_7539_();
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return this.originalModel.m_7521_();
    }

    public TextureAtlasSprite m_6160_() {
        return this.originalModel.m_6160_();
    }

    public ItemTransforms m_7442_() {
        return this.originalModel.m_7442_();
    }

    public ItemOverrides m_7343_() {
        return this.originalModel.m_7343_();
    }

    private record Geometry(BlockModel baseModel) implements IUnbakedGeometry<Geometry>
    {
        public BakedModel bake(IGeometryBakingContext owner, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
            return new CamouflageModel(this.baseModel.m_111449_(baker, this.baseModel, spriteGetter, modelTransform, modelLocation, true));
        }

        public void resolveParents(Function<ResourceLocation, UnbakedModel> modelGetter, IGeometryBakingContext context) {
            this.baseModel.m_5500_(modelGetter);
        }
    }

    public static enum Loader implements IGeometryLoader<Geometry>
    {
        INSTANCE;


        public Geometry read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) throws JsonParseException {
            BlockModel baseModel = (BlockModel)deserializationContext.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"base_model"), BlockModel.class);
            return new Geometry(baseModel);
        }
    }
}

