/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.pneumatic_armor.entity_tracker;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IEntityTrackEntry;
import me.desht.pneumaticcraft.client.pneumatic_armor.entity_tracker.EntityTrackEntryAgeable;
import me.desht.pneumaticcraft.client.pneumatic_armor.entity_tracker.EntityTrackEntryCreeper;
import me.desht.pneumaticcraft.client.pneumatic_armor.entity_tracker.EntityTrackEntryDrone;
import me.desht.pneumaticcraft.client.pneumatic_armor.entity_tracker.EntityTrackEntryHackable;
import me.desht.pneumaticcraft.client.pneumatic_armor.entity_tracker.EntityTrackEntryItemFrame;
import me.desht.pneumaticcraft.client.pneumatic_armor.entity_tracker.EntityTrackEntryLivingBase;
import me.desht.pneumaticcraft.client.pneumatic_armor.entity_tracker.EntityTrackEntryMinecart;
import me.desht.pneumaticcraft.client.pneumatic_armor.entity_tracker.EntityTrackEntryMob;
import me.desht.pneumaticcraft.client.pneumatic_armor.entity_tracker.EntityTrackEntryPainting;
import me.desht.pneumaticcraft.client.pneumatic_armor.entity_tracker.EntityTrackEntryPlayer;
import me.desht.pneumaticcraft.client.pneumatic_armor.entity_tracker.EntityTrackEntryPressurizable;
import me.desht.pneumaticcraft.client.pneumatic_armor.entity_tracker.EntityTrackEntrySlime;
import me.desht.pneumaticcraft.client.pneumatic_armor.entity_tracker.EntityTrackEntryTameable;
import net.minecraft.world.entity.Entity;
import org.apache.commons.lang3.tuple.Pair;

public enum EntityTrackHandler {
    INSTANCE;

    private boolean frozen = false;
    private final List<Supplier<? extends IEntityTrackEntry>> pendingTrackers = new CopyOnWriteArrayList<Supplier<? extends IEntityTrackEntry>>();
    private final List<Pair<Supplier<? extends IEntityTrackEntry>, IEntityTrackEntry>> trackers = new ArrayList<Pair<Supplier<? extends IEntityTrackEntry>, IEntityTrackEntry>>();

    public static EntityTrackHandler getInstance() {
        return INSTANCE;
    }

    public void registerDefaultEntries() {
        this.register(EntityTrackEntryLivingBase::new);
        this.register(EntityTrackEntryHackable::new);
        this.register(EntityTrackEntryDrone::new);
        this.register(EntityTrackEntryPressurizable::new);
        this.register(EntityTrackEntryAgeable::new);
        this.register(EntityTrackEntryTameable::new);
        this.register(EntityTrackEntryCreeper::new);
        this.register(EntityTrackEntrySlime::new);
        this.register(EntityTrackEntryPlayer::new);
        this.register(EntityTrackEntryMob::new);
        this.register(EntityTrackEntryItemFrame::new);
        this.register(EntityTrackEntryPainting::new);
        this.register(EntityTrackEntryMinecart::new);
    }

    public void register(@Nonnull Supplier<? extends IEntityTrackEntry> entry) {
        if (this.frozen) {
            throw new IllegalStateException("entity tracker registry is frozen!");
        }
        this.pendingTrackers.add(entry);
    }

    public void freeze() {
        for (Supplier<? extends IEntityTrackEntry> sup : this.pendingTrackers) {
            this.trackers.add((Pair<Supplier<? extends IEntityTrackEntry>, IEntityTrackEntry>)Pair.of(sup, (Object)sup.get()));
        }
        this.frozen = true;
    }

    public List<IEntityTrackEntry> getTrackersForEntity(Entity entity) {
        return this.trackers.stream().filter(pair -> ((IEntityTrackEntry)pair.getRight()).isApplicable(entity)).map(pair -> (IEntityTrackEntry)((Supplier)pair.getLeft()).get()).collect(Collectors.toList());
    }
}

