/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.util;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.client.util.ProgressingLine;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ComponentRenderUtils;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import org.apache.commons.lang3.StringUtils;
import org.joml.Matrix4f;

public class GuiUtils {
    private static final int TEX_WIDTH = 16;
    private static final int TEX_HEIGHT = 16;
    public static final String TRANSLATION_LINE_BREAK = "\\n";

    public static void renderBlockInGui(GuiGraphics graphics, BlockState block, float x, float y, float z, float rotate, float scale) {
        Minecraft mc = Minecraft.m_91087_();
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(x, y, z);
        poseStack.m_85841_(-scale, -scale, -scale);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(-30.0f));
        poseStack.m_252880_(-0.5f, -0.5f, 0.0f);
        poseStack.m_252880_(0.5f, 0.0f, -0.5f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(rotate));
        poseStack.m_252880_(-0.5f, 0.0f, 0.5f);
        poseStack.m_252880_(0.0f, 0.0f, -1.0f);
        mc.m_91289_().renderSingleBlock(block, poseStack, (MultiBufferSource)graphics.m_280091_(), 0xF000F0, OverlayTexture.f_118083_, ModelData.EMPTY, null);
        poseStack.m_85849_();
    }

    public static void drawFluid(GuiGraphics graphics, Rect2i bounds, @Nullable FluidStack fluidStack, @Nullable IFluidTank tank) {
        int scaledAmount;
        if (fluidStack == null || fluidStack.getFluid() == null) {
            return;
        }
        Fluid fluid = fluidStack.getFluid();
        IClientFluidTypeExtensions renderProps = IClientFluidTypeExtensions.of((Fluid)fluid);
        ResourceLocation fluidStill = renderProps.getStillTexture(fluidStack);
        if (fluidStill == null) {
            fluidStill = MissingTextureAtlasSprite.m_118071_();
        }
        TextureAtlasSprite fluidStillSprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(fluidStill);
        int n = scaledAmount = tank == null ? bounds.m_110091_() : fluidStack.getAmount() * bounds.m_110091_() / tank.getCapacity();
        if (fluidStack.getAmount() > 0 && scaledAmount < 1) {
            scaledAmount = 1;
        }
        scaledAmount = Math.min(scaledAmount, bounds.m_110091_());
        RenderSystem.setShader(GameRenderer::m_172814_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.f_118259_);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        int xTileCount = bounds.m_110090_() / 16;
        int xRemainder = bounds.m_110090_() - xTileCount * 16;
        int yTileCount = scaledAmount / 16;
        int yRemainder = scaledAmount - yTileCount * 16;
        int yStart = bounds.m_110086_() + bounds.m_110091_();
        if (fluid.getFluidType().getDensity() < 0) {
            yStart -= bounds.m_110091_() - scaledAmount;
        }
        int[] cols = RenderUtils.decomposeColor(renderProps.getTintColor(fluidStack));
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                int w = xTile == xTileCount ? xRemainder : 16;
                int h = yTile == yTileCount ? yRemainder : 16;
                int x = bounds.m_110085_() + xTile * 16;
                int y = yStart - (yTile + 1) * 16;
                if (bounds.m_110090_() <= 0 || h <= 0) continue;
                int maskTop = 16 - h;
                int maskRight = 16 - w;
                GuiUtils.drawFluidTexture(graphics, x, y, fluidStillSprite, maskTop, maskRight, 100.0f, cols);
            }
        }
        RenderSystem.disableBlend();
    }

    private static void drawFluidTexture(GuiGraphics graphics, float xCoord, float yCoord, TextureAtlasSprite textureSprite, int maskTop, int maskRight, float zLevel, int[] cols) {
        float uMin = textureSprite.m_118409_();
        float uMax = textureSprite.m_118410_();
        float vMin = textureSprite.m_118411_();
        float vMax = textureSprite.m_118412_();
        uMax -= (float)maskRight / 16.0f * (uMax - uMin);
        vMax -= (float)maskTop / 16.0f * (vMax - vMin);
        Matrix4f posMat = graphics.m_280168_().m_85850_().m_252922_();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder worldrenderer = tessellator.m_85915_();
        worldrenderer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        worldrenderer.m_252986_(posMat, xCoord, yCoord + 16.0f, zLevel).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_7421_(uMin, vMax).m_5752_();
        worldrenderer.m_252986_(posMat, xCoord + 16.0f - (float)maskRight, yCoord + 16.0f, zLevel).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_7421_(uMax, vMax).m_5752_();
        worldrenderer.m_252986_(posMat, xCoord + 16.0f - (float)maskRight, yCoord + (float)maskTop, zLevel).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_7421_(uMax, vMin).m_5752_();
        worldrenderer.m_252986_(posMat, xCoord, yCoord + (float)maskTop, zLevel).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_7421_(uMin, vMin).m_5752_();
        tessellator.m_85914_();
    }

    public static Rect2i showPopupHelpScreen(GuiGraphics graphics, Screen screen, Font fontRenderer, List<Component> helpText) {
        int y;
        int x;
        List<FormattedCharSequence> l = GuiUtils.wrapTextComponentList(helpText, screen.f_96543_ / 2, fontRenderer);
        Objects.requireNonNull(fontRenderer);
        int lineSpacing = 9 + 1;
        int boxHeight = l.size() * lineSpacing;
        int maxLines = boxHeight / lineSpacing;
        int boxWidth = l.stream().max(Comparator.comparingInt(arg_0 -> ((Font)fontRenderer).m_92724_(arg_0))).map(arg_0 -> ((Font)fontRenderer).m_92724_(arg_0)).orElse(0);
        float fontScale = 1.0f;
        while (boxHeight > screen.f_96544_ - 5) {
            boxHeight /= 2;
            boxWidth /= 2;
            fontScale /= 2.0f;
        }
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen a = (AbstractContainerScreen)screen;
            x = (a.getXSize() - boxWidth) / 2;
            y = (a.getYSize() - boxHeight) / 2;
        } else {
            x = (screen.f_96543_ - boxWidth) / 2;
            y = (screen.f_96544_ - boxHeight) / 2;
        }
        Rect2i bounds = new Rect2i(x, y, boxWidth, boxHeight);
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)x, (float)y, 400.0f);
        GuiUtils.drawPanel(graphics, 0, 0, boxHeight, boxWidth);
        int dy = 0;
        graphics.m_280168_().m_85841_(fontScale, fontScale, fontScale);
        for (FormattedCharSequence line : l) {
            graphics.m_280649_(fontRenderer, line, 0, dy, -2039584, false);
            dy += lineSpacing;
            if (maxLines-- != 0) continue;
            break;
        }
        graphics.m_280168_().m_85849_();
        return bounds;
    }

    public static void drawPanel(GuiGraphics graphics, int x, int y, int panelHeight, int panelWidth) {
        graphics.m_280509_(x - 4, y - 4, x + panelWidth + 8, y + panelHeight + 8, -1073741824);
        graphics.m_280509_(x - 4, y - 4, x + panelWidth + 8, y - 3, -8355712);
        graphics.m_280509_(x - 4, y + panelHeight + 8, x + panelWidth + 8, y + panelHeight + 9, -8355712);
        graphics.m_280509_(x - 4, y - 4, x - 3, y + panelHeight + 8, -8355712);
        graphics.m_280509_(x + panelWidth + 8, y - 4, x + panelWidth + 9, y + panelHeight + 8, -8355712);
    }

    public static void drawScaledText(GuiGraphics graphics, Font fr, Component text, int x, int y, int color, float scale, boolean dropShadow) {
        if (scale != 1.0f) {
            PoseStack poseStack = graphics.m_280168_();
            poseStack.m_85836_();
            poseStack.m_252880_((float)x, (float)y, 0.0f);
            poseStack.m_85841_(scale, scale, scale);
            graphics.m_280614_(fr, text, 0, 0, color, dropShadow);
            poseStack.m_85849_();
        } else {
            graphics.m_280614_(fr, text, x, y, color, dropShadow);
        }
    }

    public static List<FormattedCharSequence> wrapTextComponentList(List<Component> text, int maxWidth, Font font) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Component line : text) {
            builder.addAll((Iterable)ComponentRenderUtils.m_94005_((FormattedText)line, (int)maxWidth, (Font)font));
        }
        return builder.build();
    }

    public static List<Component> xlateAndSplit(String key, Object ... params) {
        return Arrays.stream(StringUtils.splitByWholeSeparator((String)I18n.m_118938_((String)key, (Object[])params), (String)TRANSLATION_LINE_BREAK)).map(Component::m_237113_).collect(Collectors.toList());
    }

    public static void renderProgressingLine2d(GuiGraphics graphics, ProgressingLine line, int color, float lineWidth) {
        int[] cols = RenderUtils.decomposeColor(color);
        float progress = line.getProgress();
        Matrix4f posMat = graphics.m_280168_().m_85850_().m_252922_();
        BufferBuilder wr = Tesselator.m_85913_().m_85915_();
        RenderSystem.lineWidth((float)lineWidth);
        RenderSystem.setShader(GameRenderer::m_172811_);
        wr.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
        wr.m_252986_(posMat, line.startX, line.startY, line.startZ).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_5752_();
        wr.m_252986_(posMat, Mth.m_14179_((float)progress, (float)line.startX, (float)line.endX), Mth.m_14179_((float)progress, (float)line.startY, (float)line.endY), Mth.m_14179_((float)progress, (float)line.startZ, (float)line.endZ)).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_5752_();
        Tesselator.m_85913_().m_85914_();
    }
}

