/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.desht.pneumaticcraft.api.crafting.ingredient.FluidIngredient;
import me.desht.pneumaticcraft.common.core.ModFluids;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;

public enum XPFluidManager {
    INSTANCE;

    private final Map<Fluid, Integer> liquidXPs = new HashMap<Fluid, Integer>();
    private List<Fluid> availableLiquidXPs = null;
    private final List<Pair<FluidIngredient, Integer>> pendingIngredients = new ArrayList<Pair<FluidIngredient, Integer>>();

    public static XPFluidManager getInstance() {
        return INSTANCE;
    }

    public void registerXPFluid(FluidIngredient fluidIngredient, int liquidToPointRatio) {
        this.pendingIngredients.add((Pair<FluidIngredient, Integer>)Pair.of((Object)((Object)fluidIngredient), (Object)liquidToPointRatio));
    }

    public int getXPRatio(Fluid fluid) {
        if (!this.pendingIngredients.isEmpty()) {
            this.resolveFluidIngredients();
            this.pendingIngredients.clear();
        }
        return this.liquidXPs.getOrDefault(fluid, 0);
    }

    private void resolveFluidIngredients() {
        for (Pair<FluidIngredient, Integer> pair : this.pendingIngredients) {
            for (FluidStack fluidStack : ((FluidIngredient)((Object)pair.getLeft())).getFluidStacks()) {
                Fluid fluid = fluidStack.getFluid();
                if (!fluid.m_7444_(fluid.m_76145_()) || fluidStack.getAmount() <= 0) continue;
                this.registerXPFluid(fluid, (Integer)pair.getRight() / fluidStack.getAmount());
            }
        }
    }

    private void registerXPFluid(Fluid fluid, int liquidToPointRatio) {
        Validate.isTrue((fluid != null && fluid != Fluids.f_76191_ ? 1 : 0) != 0, (String)"Fluid may not be null!", (Object[])new Object[0]);
        if (liquidToPointRatio <= 0) {
            this.liquidXPs.remove(fluid);
        } else {
            this.liquidXPs.put(fluid, liquidToPointRatio);
        }
        this.availableLiquidXPs = null;
    }

    public List<Fluid> getAvailableLiquidXPs() {
        if (this.availableLiquidXPs == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll(this.liquidXPs.keySet().stream().sorted((f1, f2) -> {
                if (f1 == ModFluids.MEMORY_ESSENCE.get()) {
                    return -1;
                }
                ResourceLocation r1 = PneumaticCraftUtils.getRegistryName(f1).orElseThrow();
                ResourceLocation r2 = PneumaticCraftUtils.getRegistryName(f2).orElseThrow();
                return r1.toString().compareTo(r2.toString());
            }).toList());
            this.availableLiquidXPs = builder.build();
        }
        return this.availableLiquidXPs;
    }
}

