/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.common.block.AbstractPneumaticCraftBlock;
import me.desht.pneumaticcraft.common.block.FluidTankBlock;
import me.desht.pneumaticcraft.common.block.entity.AbstractTickingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IComparatorSupport;
import me.desht.pneumaticcraft.common.block.entity.ISerializableTanks;
import me.desht.pneumaticcraft.common.block.entity.SmartSyncTank;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import me.desht.pneumaticcraft.common.inventory.FluidTankMenu;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.LazySynced;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PNCFluidTank;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractFluidTankBlockEntity
extends AbstractTickingBlockEntity
implements ISerializableTanks,
MenuProvider,
IComparatorSupport {
    private static final int INVENTORY_SIZE = 2;
    private static final int INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 1;
    private static final int BASE_EJECT_RATE = 25;
    @LazySynced
    @DescSynced
    @GuiSynced
    private final StackableTank tank;
    private final LazyOptional<IFluidHandler> fluidCap;
    private final ItemStackHandler inventory = new BaseItemStackHandler(this, 2){

        public boolean isItemValid(int slot, ItemStack itemStack) {
            return itemStack.m_41619_() || FluidUtil.getFluidHandler((ItemStack)itemStack).isPresent();
        }
    };
    private final LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);

    AbstractFluidTankBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, FluidTankBlock.Size tankSize) {
        super(type, pos, state, 4);
        this.tank = new StackableTank(tankSize.getCapacity());
        this.fluidCap = LazyOptional.of(() -> this.tank);
    }

    @Override
    public void tickCommonPre() {
        super.tickCommonPre();
        this.tank.tick();
    }

    @Override
    public void tickServer() {
        Direction ejectDir;
        super.tickServer();
        this.processFluidItem(0, 1);
        FluidStack stack = this.getTank().getFluid();
        if (!stack.isEmpty()) {
            BlockEntity teOther;
            BlockState other;
            Direction dir;
            Direction direction = dir = stack.getFluid().getFluidType().isLighterThanAir() ? Direction.UP : Direction.DOWN;
            if (((Boolean)this.m_58900_().m_61143_((Property)AbstractPneumaticCraftBlock.connectionProperty(dir))).booleanValue() && (other = this.nonNullLevel().m_8055_(this.f_58858_.m_121945_(dir))).m_60734_() instanceof FluidTankBlock && ((Boolean)other.m_61143_((Property)AbstractPneumaticCraftBlock.connectionProperty(dir.m_122424_()))).booleanValue() && (teOther = this.getCachedNeighbor(dir)) instanceof AbstractFluidTankBlockEntity) {
                FluidUtil.tryFluidTransfer((IFluidHandler)((AbstractFluidTankBlockEntity)teOther).getTank(), (IFluidHandler)this.tank, (int)(this.tank.getCapacity() / 32), (boolean)true);
            }
        }
        if (!((ejectDir = this.getUpgradeCache().getEjectDirection()) == null || ejectDir.m_122434_() == Direction.Axis.Y && ((Boolean)this.m_58900_().m_61143_((Property)AbstractPneumaticCraftBlock.connectionProperty(ejectDir))).booleanValue())) {
            IOHelper.getFluidHandlerForTE(this.getCachedNeighbor(ejectDir), ejectDir.m_122424_()).ifPresent(h -> {
                int amount = 25 << this.getUpgrades(ModUpgrades.SPEED.get());
                FluidUtil.tryFluidTransfer((IFluidHandler)h, (IFluidHandler)this.tank, (int)amount, (boolean)true);
            });
        }
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.inventory;
    }

    @Override
    @Nonnull
    protected LazyOptional<IItemHandler> getInventoryCap(Direction side) {
        return this.inventoryCap;
    }

    @Override
    @NotNull
    public LazyOptional<IFluidHandler> getFluidCap(Direction side) {
        return this.fluidCap;
    }

    @Override
    @Nonnull
    public Map<String, PNCFluidTank> getSerializableTanks() {
        return ImmutableMap.of((Object)"Tank", (Object)this.tank);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Items", (Tag)this.inventory.serializeNBT());
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inventory.deserializeNBT(tag.m_128469_("Items"));
    }

    public SmartSyncTank getTank() {
        return this.tank;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new FluidTankMenu(windowId, inv, this.m_58899_());
    }

    public boolean isNeighbourCompatible(FluidStack stack, Direction dir) {
        BlockState state = this.m_58900_();
        AbstractFluidTankBlockEntity curTank = this;
        while (state.m_60734_() instanceof FluidTankBlock) {
            if (!((Boolean)state.m_61143_((Property)AbstractPneumaticCraftBlock.connectionProperty(dir))).booleanValue()) {
                return true;
            }
            BlockEntity teOther = curTank.getCachedNeighbor(dir);
            if (teOther instanceof AbstractFluidTankBlockEntity) {
                curTank = (AbstractFluidTankBlockEntity)teOther;
                state = curTank.m_58900_();
                if (this.isFluidCompatible(stack, curTank.getTank())) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public boolean isFluidCompatible(FluidStack stack, IFluidTank tank) {
        return stack.isEmpty() || tank.getFluid().isEmpty() || stack.getFluid() == tank.getFluid().getFluid();
    }

    @Override
    public int getComparatorValue() {
        return this.tank.isEmpty() ? 0 : 1 + this.tank.getFluidAmount() * 14 / this.tank.getCapacity();
    }

    public class StackableTank
    extends SmartSyncTank {
        StackableTank(int capacity) {
            super(AbstractFluidTankBlockEntity.this, capacity);
        }

        @Override
        public boolean isFluidValid(FluidStack stack) {
            return AbstractFluidTankBlockEntity.this.isNeighbourCompatible(stack, Direction.UP) && AbstractFluidTankBlockEntity.this.isNeighbourCompatible(stack, Direction.DOWN);
        }
    }

    public static class Huge
    extends AbstractFluidTankBlockEntity {
        public Huge(BlockPos pos, BlockState state) {
            super((BlockEntityType)ModBlockEntities.TANK_HUGE.get(), pos, state, FluidTankBlock.Size.HUGE);
        }
    }

    public static class Large
    extends AbstractFluidTankBlockEntity {
        public Large(BlockPos pos, BlockState state) {
            super((BlockEntityType)ModBlockEntities.TANK_LARGE.get(), pos, state, FluidTankBlock.Size.LARGE);
        }
    }

    public static class Medium
    extends AbstractFluidTankBlockEntity {
        public Medium(BlockPos pos, BlockState state) {
            super((BlockEntityType)ModBlockEntities.TANK_MEDIUM.get(), pos, state, FluidTankBlock.Size.MEDIUM);
        }
    }

    public static class Small
    extends AbstractFluidTankBlockEntity {
        public Small(BlockPos pos, BlockState state) {
            super((BlockEntityType)ModBlockEntities.TANK_SMALL.get(), pos, state, FluidTankBlock.Size.SMALL);
        }
    }
}

