/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.crafting.recipe.FluidMixerRecipe;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IAutoFluidEjecting;
import me.desht.pneumaticcraft.common.block.entity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.block.entity.ISerializableTanks;
import me.desht.pneumaticcraft.common.block.entity.RedstoneController;
import me.desht.pneumaticcraft.common.block.entity.SmartSyncTank;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import me.desht.pneumaticcraft.common.core.ModRecipeTypes;
import me.desht.pneumaticcraft.common.inventory.FluidMixerMenu;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.inventory.handler.OutputItemHandler;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.util.PNCFluidTank;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class FluidMixerBlockEntity
extends AbstractAirHandlingBlockEntity
implements IMinWorkingPressure,
IRedstoneControl<FluidMixerBlockEntity>,
MenuProvider,
ISerializableTanks,
IAutoFluidEjecting {
    private static final Map<Fluid, Set<Fluid>> FLUID_MATCHES = new HashMap<Fluid, Set<Fluid>>();
    private final ItemStackHandler outputInv = new BaseItemStackHandler(this, 1);
    private final OutputItemHandler outputInvWrapper = new OutputItemHandler((IItemHandlerModifiable)this.outputInv);
    private final LazyOptional<IItemHandler> invCap = LazyOptional.of(() -> this.outputInvWrapper);
    @GuiSynced
    @DescSynced
    private final SmartSyncTank inputTank1 = new InputTank();
    @GuiSynced
    @DescSynced
    private final SmartSyncTank inputTank2 = new InputTank();
    @GuiSynced
    @DescSynced
    private final SmartSyncTank outputTank = new SmartSyncTank(this, 16000);
    @GuiSynced
    private float requiredPressure;
    @GuiSynced
    public int craftingProgress = 0;
    @GuiSynced
    public int maxProgress;
    @DescSynced
    public boolean didWork;
    @GuiSynced
    private final RedstoneController<FluidMixerBlockEntity> rsController = new RedstoneController<FluidMixerBlockEntity>(this);
    @GuiSynced
    private String currentRecipeIdSynced = "";
    private float airUsed;
    private FluidMixerRecipe currentRecipe = null;
    private boolean searchRecipes = true;
    private final MixerFluidHandler fluidHandler = new MixerFluidHandler();
    private final LazyOptional<IFluidHandler> fluidCap = LazyOptional.of(() -> this.fluidHandler);
    private final SmartSyncTank[] tanks = new SmartSyncTank[]{this.inputTank1, this.inputTank2, this.outputTank};

    public FluidMixerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.FLUID_MIXER.get(), pos, state, PressureTier.TIER_ONE, 3000, 4);
    }

    @Override
    public void tickCommonPre() {
        super.tickCommonPre();
        this.inputTank1.tick();
        this.inputTank2.tick();
        this.outputTank.tick();
    }

    @Override
    public void tickClient() {
        super.tickClient();
        if (this.didWork && this.nonNullLevel().f_46441_.m_188501_() < 0.1f) {
            ClientUtils.emitParticles(this.f_58857_, this.f_58858_, (ParticleOptions)ParticleTypes.f_123761_);
        }
    }

    @Override
    public void tickServer() {
        super.tickServer();
        this.didWork = false;
        if (this.searchRecipes) {
            this.currentRecipe = this.findApplicableRecipe();
            this.currentRecipeIdSynced = this.currentRecipe == null ? "" : this.currentRecipe.m_6423_().toString();
            this.requiredPressure = this.currentRecipe != null ? this.currentRecipe.getRequiredPressure() : 0.0f;
            this.maxProgress = this.currentRecipe != null ? this.currentRecipe.getProcessingTime() * 100 : 0;
            this.searchRecipes = false;
        }
        if (this.rsController.shouldRun() && this.currentRecipe != null && this.getPressure() >= this.requiredPressure && this.hasOutputSpace()) {
            this.craftingProgress = (int)((float)this.craftingProgress + 100.0f * (1.0f + Math.min(this.getPressure() - this.requiredPressure, 1.5f)));
            this.didWork = true;
            this.airUsed += 2.5f * this.getPressure();
            if (this.airUsed > 1.0f) {
                int a = (int)this.airUsed;
                this.airHandler.addAir(-a);
                this.airUsed -= (float)a;
            }
            if (this.craftingProgress >= this.maxProgress && this.takeInputIngredients()) {
                if (!this.currentRecipe.getOutputFluid().isEmpty()) {
                    this.outputTank.fill(this.currentRecipe.getOutputFluid().copy(), IFluidHandler.FluidAction.EXECUTE);
                }
                if (!this.currentRecipe.getOutputItem().m_41619_()) {
                    this.outputInv.insertItem(0, this.currentRecipe.getOutputItem().m_41777_(), false);
                }
                this.craftingProgress -= this.maxProgress;
            }
        }
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Items", (Tag)this.outputInv.serializeNBT());
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.outputInv.deserializeNBT(tag.m_128469_("Items"));
    }

    @Override
    public String getCurrentRecipeIdSynced() {
        return this.currentRecipeIdSynced;
    }

    private boolean takeInputIngredients() {
        if (this.currentRecipe.getInput1().testFluid(this.inputTank1.getFluid()) && this.currentRecipe.getInput2().testFluid(this.inputTank2.getFluid())) {
            this.inputTank1.drain(this.currentRecipe.getInput1().getAmount(), IFluidHandler.FluidAction.EXECUTE);
            this.inputTank2.drain(this.currentRecipe.getInput2().getAmount(), IFluidHandler.FluidAction.EXECUTE);
            return true;
        }
        if (this.currentRecipe.getInput2().testFluid(this.inputTank1.getFluid()) && this.currentRecipe.getInput1().testFluid(this.inputTank2.getFluid())) {
            this.inputTank1.drain(this.currentRecipe.getInput2().getAmount(), IFluidHandler.FluidAction.EXECUTE);
            this.inputTank2.drain(this.currentRecipe.getInput1().getAmount(), IFluidHandler.FluidAction.EXECUTE);
            return true;
        }
        return false;
    }

    public boolean hasOutputSpace() {
        if (!this.currentRecipe.getOutputItem().m_41619_() && !this.outputInv.insertItem(0, this.currentRecipe.getOutputItem(), true).m_41619_()) {
            return false;
        }
        return this.currentRecipe.getOutputFluid().isEmpty() || this.outputTank.fill(this.currentRecipe.getOutputFluid(), IFluidHandler.FluidAction.SIMULATE) >= this.currentRecipe.getOutputFluid().getAmount();
    }

    private FluidMixerRecipe findApplicableRecipe() {
        for (FluidMixerRecipe recipe : ModRecipeTypes.getRecipes(this.f_58857_, ModRecipeTypes.FLUID_MIXER)) {
            if (!recipe.matches(this.inputTank1.getFluid(), this.inputTank2.getFluid())) continue;
            return recipe;
        }
        return null;
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.outputInvWrapper;
    }

    @Override
    @Nonnull
    protected LazyOptional<IItemHandler> getInventoryCap(Direction side) {
        return this.invCap;
    }

    @Override
    @NotNull
    public LazyOptional<IFluidHandler> getFluidCap(Direction side) {
        return this.fluidCap.cast();
    }

    @Override
    public boolean canConnectPneumatic(Direction side) {
        return side != Direction.UP && side != this.getRotation();
    }

    public static void clearCachedFluids() {
        FLUID_MATCHES.clear();
    }

    public static void cacheRecipeFluids(List<FluidMixerRecipe> values) {
        for (FluidMixerRecipe recipe : values) {
            for (FluidStack input1 : recipe.getInput1().getFluidStacks()) {
                for (FluidStack input2 : recipe.getInput2().getFluidStacks()) {
                    Set fluidSet1 = FLUID_MATCHES.computeIfAbsent(input1.getFluid(), k -> new HashSet());
                    Set fluidSet2 = FLUID_MATCHES.computeIfAbsent(input2.getFluid(), k -> new HashSet());
                    fluidSet1.add(input2.getFluid());
                    fluidSet2.add(input1.getFluid());
                }
            }
        }
    }

    public static boolean isFluidAccepted(Fluid fluid) {
        return FLUID_MATCHES.containsKey(fluid);
    }

    public static boolean isFluidMatch(Fluid fluid1, Fluid fluid2) {
        Set<Fluid> fluids = FLUID_MATCHES.get(fluid1);
        return fluids != null && fluids.contains(fluid2);
    }

    @Override
    public float getMinWorkingPressure() {
        return this.requiredPressure;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new FluidMixerMenu(windowId, inv, this.f_58858_);
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        if (this.rsController.parseRedstoneMode(tag)) {
            return;
        }
        if (tag.startsWith("dump")) {
            try {
                this.moveOrDump((Player)player, Integer.parseInt(tag.substring(4)), shiftHeld);
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            super.handleGUIButtonPress(tag, shiftHeld, player);
        }
    }

    private void moveOrDump(Player player, int tank, boolean shiftHeld) {
        SmartSyncTank inputTank = tank == 1 ? this.inputTank1 : this.inputTank2;
        FluidStack moved = shiftHeld ? inputTank.drain(inputTank.getCapacity(), IFluidHandler.FluidAction.EXECUTE) : FluidUtil.tryFluidTransfer((IFluidHandler)this.outputTank, (IFluidHandler)inputTank, (int)inputTank.getFluidAmount(), (boolean)true);
        if (!moved.isEmpty() && player instanceof ServerPlayer) {
            NetworkHandler.sendToPlayer(new PacketPlaySound(SoundEvents.f_11781_, SoundSource.BLOCKS, this.f_58858_, 1.0f, 1.0f, false), (ServerPlayer)player);
        }
    }

    @Override
    public RedstoneController<FluidMixerBlockEntity> getRedstoneController() {
        return this.rsController;
    }

    @Override
    @Nonnull
    public Map<String, PNCFluidTank> getSerializableTanks() {
        return ImmutableMap.of((Object)"Input1", (Object)this.inputTank1, (Object)"Input2", (Object)this.inputTank2, (Object)"Output", (Object)this.outputTank);
    }

    public IFluidTank getInputTank1() {
        return this.inputTank1;
    }

    public IFluidTank getInputTank2() {
        return this.inputTank2;
    }

    public IFluidTank getOutputTank() {
        return this.outputTank;
    }

    public float getCraftingPercentage() {
        return this.maxProgress > 0 ? (float)this.craftingProgress / (float)this.maxProgress : 0.0f;
    }

    private class InputTank
    extends SmartSyncTank {
        InputTank() {
            super(FluidMixerBlockEntity.this, 16000);
        }

        @Override
        protected void onContentsChanged(Fluid prevFluid, int prevAmount) {
            super.onContentsChanged(prevFluid, prevAmount);
            FluidMixerBlockEntity.this.searchRecipes = true;
        }
    }

    private class MixerFluidHandler
    implements IFluidHandler {
        private MixerFluidHandler() {
        }

        public int getTanks() {
            return 3;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return FluidMixerBlockEntity.this.tanks[tank].getFluid();
        }

        public int getTankCapacity(int tank) {
            return FluidMixerBlockEntity.this.tanks[tank].getCapacity();
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return FluidMixerBlockEntity.this.tanks[tank].isFluidValid(stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (FluidMixerBlockEntity.isFluidAccepted(resource.getFluid())) {
                if (FluidMixerBlockEntity.this.inputTank1.isEmpty() && FluidMixerBlockEntity.this.inputTank2.isEmpty()) {
                    return FluidMixerBlockEntity.this.inputTank1.fill(resource, action);
                }
                if (FluidMixerBlockEntity.this.inputTank2.isEmpty()) {
                    if (resource.getFluid() == FluidMixerBlockEntity.this.inputTank1.getFluid().getFluid()) {
                        return FluidMixerBlockEntity.this.inputTank1.fill(resource, action);
                    }
                    if (FluidMixerBlockEntity.isFluidMatch(resource.getFluid(), FluidMixerBlockEntity.this.inputTank1.getFluid().getFluid())) {
                        return FluidMixerBlockEntity.this.inputTank2.fill(resource, action);
                    }
                } else if (FluidMixerBlockEntity.this.inputTank1.isEmpty()) {
                    if (resource.getFluid() == FluidMixerBlockEntity.this.inputTank2.getFluid().getFluid()) {
                        return FluidMixerBlockEntity.this.inputTank2.fill(resource, action);
                    }
                    if (FluidMixerBlockEntity.isFluidMatch(resource.getFluid(), FluidMixerBlockEntity.this.inputTank2.getFluid().getFluid())) {
                        return FluidMixerBlockEntity.this.inputTank1.fill(resource, action);
                    }
                } else {
                    int filled = FluidMixerBlockEntity.this.inputTank1.fill(resource, action);
                    return filled == 0 ? FluidMixerBlockEntity.this.inputTank2.fill(resource, action) : filled;
                }
            }
            return 0;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return FluidMixerBlockEntity.this.outputTank.drain(resource, action);
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return FluidMixerBlockEntity.this.outputTank.drain(maxDrain, action);
        }
    }
}

