/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import java.util.function.BiPredicate;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.common.block.entity.AbstractTickingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.CamouflageableBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IHeatExchangingTE;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class HeatPipeBlockEntity
extends AbstractTickingBlockEntity
implements CamouflageableBlockEntity,
IHeatExchangingTE {
    public static final BiPredicate<LevelAccessor, BlockPos> NO_AIR_OR_LIQUIDS = (world, pos) -> !world.m_46859_(pos) && !(world.m_8055_(pos).m_60734_() instanceof LiquidBlock);
    private final IHeatExchangerLogic heatExchanger = PneumaticRegistry.getInstance().getHeatRegistry().makeHeatExchangerLogic();
    private final LazyOptional<IHeatExchangerLogic> heatCap = LazyOptional.of(() -> this.heatExchanger);
    private BlockState camoState;

    public HeatPipeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<?>)((BlockEntityType)ModBlockEntities.HEAT_PIPE.get()), pos, state);
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return null;
    }

    @Override
    public LazyOptional<IHeatExchangerLogic> getHeatCap(Direction side) {
        return this.heatCap;
    }

    @Override
    public BiPredicate<LevelAccessor, BlockPos> heatExchangerBlockFilter() {
        return NO_AIR_OR_LIQUIDS;
    }

    @Override
    public void writeToPacket(CompoundTag tag) {
        super.writeToPacket(tag);
        CamouflageableBlockEntity.writeCamo(tag, this.camoState);
    }

    @Override
    public void readFromPacket(CompoundTag tag) {
        super.readFromPacket(tag);
        this.camoState = CamouflageableBlockEntity.readCamo(tag);
    }

    @Override
    public BlockState getCamouflage() {
        return this.camoState;
    }

    @Override
    public void setCamouflage(BlockState state) {
        this.camoState = state;
        CamouflageableBlockEntity.syncToClient(this);
    }

    @Override
    public IHeatExchangerLogic getHeatExchanger(Direction dir) {
        return this.heatExchanger;
    }
}

