/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.common.heat.HeatExchangerLogicAmbient;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

@FunctionalInterface
public interface IHeatExchangingTE {
    @Nullable
    public IHeatExchangerLogic getHeatExchanger(Direction var1);

    default public IHeatExchangerLogic getHeatExchanger() {
        return this.getHeatExchanger(null);
    }

    default public BiPredicate<LevelAccessor, BlockPos> heatExchangerBlockFilter() {
        return IHeatExchangerLogic.ALL_BLOCKS;
    }

    default public void initHeatExchangersOnPlacement(Level world, BlockPos pos) {
        IHeatExchangerLogic logic = this.getHeatExchanger();
        if (logic != null) {
            logic.setTemperature(HeatExchangerLogicAmbient.getAmbientTemperature((LevelAccessor)world, pos));
        }
    }

    default public void initializeHullHeatExchangers(Level world, BlockPos pos) {
        IdentityHashMap<IHeatExchangerLogic, List> map = new IdentityHashMap<IHeatExchangerLogic, List>();
        for (Direction side : DirectionUtil.VALUES) {
            IHeatExchangerLogic logic2 = this.getHeatExchanger(side);
            if (logic2 == null) continue;
            map.computeIfAbsent(logic2, k -> new ArrayList()).add(side);
        }
        map.forEach((logic, sides) -> logic.initializeAsHull(world, pos, this.heatExchangerBlockFilter(), sides.toArray(new Direction[0])));
    }

    default public boolean shouldShowGuiHeatTab() {
        return true;
    }
}

