/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import me.desht.pneumaticcraft.common.block.PneumaticDoorBlock;
import me.desht.pneumaticcraft.common.block.entity.AbstractTickingBlockEntity;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.LazySynced;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.items.IItemHandler;

public class PneumaticDoorBlockEntity
extends AbstractTickingBlockEntity {
    @DescSynced
    @LazySynced
    public float rotationAngle;
    public float oldRotationAngle;
    @DescSynced
    public boolean rightGoing;
    @DescSynced
    public int color = DyeColor.WHITE.m_41060_();

    public PneumaticDoorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<?>)((BlockEntityType)ModBlockEntities.PNEUMATIC_DOOR.get()), pos, state);
    }

    public void setRotationAngle(float rotationAngle) {
        if (this.oldRotationAngle == rotationAngle) {
            return;
        }
        this.oldRotationAngle = this.rotationAngle;
        this.rotationAngle = rotationAngle;
        if (this.oldRotationAngle < 90.0f && rotationAngle == 90.0f) {
            this.nonNullLevel().m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)DoorBlock.f_52727_, (Comparable)Boolean.valueOf(true)));
        } else if (this.oldRotationAngle == 90.0f && rotationAngle < 90.0f) {
            this.nonNullLevel().m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)DoorBlock.f_52727_, (Comparable)Boolean.valueOf(false)));
        }
        BlockPos otherPos = this.m_58899_().m_121945_(this.isTopDoor() ? Direction.DOWN : Direction.UP);
        PneumaticCraftUtils.getTileEntityAt((BlockGetter)this.m_58904_(), otherPos, PneumaticDoorBlockEntity.class).ifPresent(otherDoorHalf -> {
            otherDoorHalf.rightGoing = this.rightGoing;
            otherDoorHalf.m_6596_();
            if (rotationAngle != otherDoorHalf.rotationAngle) {
                otherDoorHalf.setRotationAngle(rotationAngle);
            }
        });
    }

    public boolean setColor(DyeColor dyeColor) {
        if (this.color != dyeColor.m_41060_() && !((Boolean)this.m_58900_().m_61143_((Property)PneumaticDoorBlock.TOP_DOOR)).booleanValue()) {
            this.color = (byte)dyeColor.m_41060_();
            this.nonNullLevel().m_141902_(this.m_58899_(), (BlockEntityType)ModBlockEntities.PNEUMATIC_DOOR.get()).ifPresent(topHalf -> {
                topHalf.color = this.color;
                if (!this.nonNullLevel().f_46443_) {
                    this.m_6596_();
                    topHalf.m_6596_();
                    this.sendDescriptionPacket();
                }
            });
            return true;
        }
        return false;
    }

    private boolean isTopDoor() {
        return PneumaticDoorBlock.isTopDoor(this.nonNullLevel().m_8055_(this.m_58899_()));
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("rightGoing", this.rightGoing);
        tag.m_128405_("color", this.color);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.rightGoing = tag.m_128471_("rightGoing");
        this.color = tag.m_128451_("color");
        this.scheduleDescriptionPacket();
    }

    @Override
    public void serializeExtraItemData(CompoundTag blockEntityTag, boolean preserveState) {
        super.serializeExtraItemData(blockEntityTag, preserveState);
        blockEntityTag.m_128405_("color", this.color);
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return null;
    }

    public AABB getRenderBoundingBox() {
        return new AABB((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), (double)(this.m_58899_().m_123341_() + 1), (double)(this.m_58899_().m_123342_() + 2), (double)(this.m_58899_().m_123343_() + 1));
    }

    @Override
    public boolean shouldPreserveStateOnBreak() {
        return true;
    }
}

