/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.config.subconfig;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashSet;
import java.util.Set;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.config.subconfig.AuxConfigJson;
import me.desht.pneumaticcraft.common.config.subconfig.IAuxConfig;
import me.desht.pneumaticcraft.common.core.ModProgWidgets;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.resources.ResourceLocation;

public class ProgWidgetConfig
extends AuxConfigJson {
    private final Set<ResourceLocation> blacklistedPieces = new HashSet<ResourceLocation>();
    public static final ProgWidgetConfig INSTANCE = new ProgWidgetConfig();

    private ProgWidgetConfig() {
        super(false);
    }

    public boolean isWidgetBlacklisted(ProgWidgetType<?> widgetType) {
        ResourceLocation regName = PneumaticCraftUtils.getRegistryName(ModProgWidgets.PROG_WIDGETS.get(), widgetType).orElseThrow();
        return this.blacklistedPieces.contains(regName);
    }

    @Override
    public String getConfigFilename() {
        return "ProgrammingPuzzleBlacklist";
    }

    @Override
    protected void writeToJson(JsonObject json) {
        json.addProperty("description", "In the 'blacklist' tag you can add any progwidget registry names you wish to blacklist from this instance. When they were used in existing programs already they will be deleted. A reference list of all known programming puzzle names can be seen in 'allWidgets'.");
        JsonArray array = new JsonArray();
        for (ResourceLocation name : this.blacklistedPieces) {
            array.add((JsonElement)new JsonPrimitive(name.toString()));
        }
        json.add("blacklist", (JsonElement)array);
        JsonArray allArray = new JsonArray();
        for (ResourceLocation entry : ModProgWidgets.PROG_WIDGETS.get().getKeys()) {
            allArray.add((JsonElement)new JsonPrimitive(entry.toString()));
        }
        json.add("allWidgets", (JsonElement)allArray);
    }

    @Override
    protected void readFromJson(JsonObject json) {
        JsonArray array = json.get("blacklist").getAsJsonArray();
        this.blacklistedPieces.clear();
        for (JsonElement element : array) {
            this.blacklistedPieces.add(new ResourceLocation(element.getAsString()));
        }
    }

    @Override
    public IAuxConfig.Sidedness getSidedness() {
        return IAuxConfig.Sidedness.BOTH;
    }
}

