/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.ai;

import java.util.EnumSet;
import java.util.List;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.drone.ai.DistanceEntitySorter;
import me.desht.pneumaticcraft.common.drone.progwidgets.IItemPickupWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.util.IOHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;

public class DroneEntityAIPickupItems
extends Goal {
    private final IDroneBase drone;
    private final ProgWidgetAreaItemBase itemPickupWidget;
    private ItemEntity curPickingUpEntity;
    private final DistanceEntitySorter theNearestAttackableTargetSorter;
    private final boolean canSteal;
    private static final Direction[] DIRECTIONS = new Direction[]{Direction.UP, Direction.NORTH, Direction.WEST, Direction.EAST, Direction.SOUTH, Direction.DOWN};

    public DroneEntityAIPickupItems(IDroneBase drone, ProgWidgetAreaItemBase progWidgetPickupItem) {
        this.drone = drone;
        this.m_7021_(EnumSet.allOf(Goal.Flag.class));
        this.itemPickupWidget = progWidgetPickupItem;
        this.theNearestAttackableTargetSorter = new DistanceEntitySorter(drone);
        if (!(progWidgetPickupItem instanceof IItemPickupWidget)) {
            throw new IllegalArgumentException("expecting a IItemPickupWidget!");
        }
        this.canSteal = ((IItemPickupWidget)((Object)this.itemPickupWidget)).canSteal();
    }

    public boolean m_8036_() {
        List<Entity> pickableItems = this.itemPickupWidget.getEntitiesInArea(this.drone.world(), entity -> entity instanceof ItemEntity && entity.m_6084_());
        if (pickableItems.isEmpty()) {
            this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.itemPickup.debug.noItems");
            return false;
        }
        pickableItems.sort(this.theNearestAttackableTargetSorter);
        for (Entity ent : pickableItems) {
            if (ent.getPersistentData().m_128471_("PreventRemoteMovement") && !this.canSteal) continue;
            ItemStack stack = ((ItemEntity)ent).m_32055_();
            if (this.itemPickupWidget.isItemValidForFilters(stack)) {
                if (IOHelper.insert(this.drone, stack, null, true).m_41619_()) {
                    return this.tryMoveToItem(ent);
                }
                this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.inventoryImport.debug.filledToMax");
                continue;
            }
            this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.itemPickup.debug.itemNotValid");
        }
        return false;
    }

    private boolean tryMoveToItem(Entity ent) {
        if (!this.drone.isBlockValidPathfindBlock(ent.m_20183_())) {
            for (Direction d : DIRECTIONS) {
                BlockPos pos2 = ent.m_20183_().m_121945_(d);
                if (!this.drone.isBlockValidPathfindBlock(pos2) || !this.drone.getPathNavigator().moveToXYZ((double)pos2.m_123341_() + 0.5, (double)pos2.m_123342_() + 0.5, (double)pos2.m_123343_() + 0.5)) continue;
                this.curPickingUpEntity = (ItemEntity)ent;
                return true;
            }
        } else {
            if (this.drone.getPathNavigator().moveToEntity(ent)) {
                this.curPickingUpEntity = (ItemEntity)ent;
                return true;
            }
            this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.general.debug.cantNavigate");
        }
        return false;
    }

    public boolean m_8045_() {
        if (!this.curPickingUpEntity.m_6084_()) {
            return false;
        }
        if (this.curPickingUpEntity.m_20182_().m_82557_(this.drone.getDronePos()) < 4.0) {
            ItemStack stack = this.curPickingUpEntity.m_32055_();
            if (this.itemPickupWidget.isItemValidForFilters(stack)) {
                DroneEntityAIPickupItems.tryPickupItem(this.drone, this.curPickingUpEntity);
            }
            return false;
        }
        return !this.drone.getPathNavigator().hasNoPath();
    }

    static void tryPickupItem(IDrone drone, ItemEntity itemEntity) {
        ItemStack remainder;
        ItemStack stack = itemEntity.m_32055_();
        int stackSize = stack.m_41613_();
        int collected = stackSize - (remainder = IOHelper.insert(drone, stack, null, false)).m_41613_();
        if (collected > 0) {
            drone.onItemPickupEvent(itemEntity, collected);
        }
        if (remainder.m_41619_()) {
            itemEntity.m_146870_();
        } else if (collected > 0) {
            itemEntity.m_32045_(remainder);
        }
    }
}

