/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.List;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.core.ModProgWidgets;
import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIBlockCondition;
import me.desht.pneumaticcraft.common.drone.progwidgets.ICondition;
import me.desht.pneumaticcraft.common.drone.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ISidedWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetCondition;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;

public class ProgWidgetItemInventoryCondition
extends ProgWidgetCondition {
    public ProgWidgetItemInventoryCondition() {
        super((ProgWidgetType)ModProgWidgets.CONDITION_ITEM_INVENTORY.get());
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of((Object)((ProgWidgetType)ModProgWidgets.AREA.get()), (Object)((ProgWidgetType)ModProgWidgets.ITEM_FILTER.get()), (Object)((ProgWidgetType)ModProgWidgets.TEXT.get()));
    }

    @Override
    protected DroneAIBlockCondition getEvaluator(IDroneBase drone, IProgWidget widget) {
        return new DroneAIBlockCondition(drone, (ProgWidgetAreaItemBase)widget){

            @Override
            protected boolean evaluate(BlockPos pos) {
                BlockEntity te = this.drone.world().m_7702_(pos);
                boolean[] sides = ((ISidedWidget)((Object)this.progWidget)).getSides();
                HashSet handlers = new HashSet();
                for (int sideIdx = 0; sideIdx < sides.length; ++sideIdx) {
                    if (!sides[sideIdx]) continue;
                    IOHelper.getInventoryForTE(te, Direction.m_122376_((int)sideIdx)).ifPresent(handlers::add);
                }
                int count = 0;
                for (IItemHandler handler : handlers) {
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        ItemStack stack = handler.getStackInSlot(i);
                        if (!this.progWidget.isItemValidForFilters(stack)) continue;
                        count += stack.m_41613_();
                    }
                }
                ProgWidgetItemInventoryCondition.this.maybeRecordMeasuredVal(this.drone, count);
                return ((ICondition)((Object)this.progWidget)).getOperator().evaluate(count, ((ICondition)((Object)this.progWidget)).getRequiredCount());
            }
        };
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_CONDITION_ITEM_INVENTORY;
    }
}

