/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets.area;

import java.util.List;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.common.drone.progwidgets.area.AreaType;
import me.desht.pneumaticcraft.common.util.ITranslatableEnum;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;

public class AreaTypeSphere
extends AreaType {
    public static final String ID = "sphere";
    private EnumSphereType sphereType = EnumSphereType.FILLED;

    public AreaTypeSphere() {
        super(ID);
    }

    public String toString() {
        return this.getName() + "/" + String.valueOf(this.sphereType);
    }

    @Override
    public void addArea(Consumer<BlockPos> areaAdder, BlockPos p1, BlockPos p2, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        double radius = PneumaticCraftUtils.distBetween((Vec3i)p1, (Vec3i)p2);
        double radiusSq = radius * radius;
        double innerRadius = this.sphereType == EnumSphereType.HOLLOW ? radius - 1.0 : 0.0;
        double innerRadiusSq = innerRadius * innerRadius;
        minX = (int)((double)p1.m_123341_() - radius - 1.0);
        minY = (int)((double)p1.m_123342_() - radius - 1.0);
        minZ = (int)((double)p1.m_123343_() - radius - 1.0);
        maxX = (int)((double)p1.m_123341_() + radius + 1.0);
        maxY = (int)((double)p1.m_123342_() + radius + 1.0);
        maxZ = (int)((double)p1.m_123343_() + radius + 1.0);
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    double centerDistSq = PneumaticCraftUtils.distBetweenSq((Vec3i)p1, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
                    if (!(centerDistSq <= radiusSq) || !(centerDistSq >= innerRadiusSq)) continue;
                    areaAdder.accept(new BlockPos(x, y, z));
                }
            }
        }
    }

    @Override
    public void addUIWidgets(List<AreaType.AreaTypeWidget> widgets) {
        super.addUIWidgets(widgets);
        widgets.add(new AreaType.AreaTypeWidgetEnum<EnumSphereType>("pneumaticcraft.gui.progWidget.area.type.sphere.sphereType", EnumSphereType.class, () -> this.sphereType, sphereType -> {
            this.sphereType = sphereType;
        }));
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        tag.m_128344_("sphereType", (byte)this.sphereType.ordinal());
    }

    @Override
    public void writeToPacket(FriendlyByteBuf buffer) {
        super.writeToPacket(buffer);
        buffer.writeByte(this.sphereType.ordinal());
    }

    @Override
    public void readFromPacket(FriendlyByteBuf buf) {
        super.readFromPacket(buf);
        this.sphereType = EnumSphereType.values()[buf.readByte()];
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.sphereType = EnumSphereType.values()[tag.m_128445_("sphereType")];
    }

    private static enum EnumSphereType implements ITranslatableEnum
    {
        FILLED("filled"),
        HOLLOW("hollow");

        private final String name;

        private EnumSphereType(String name) {
            this.name = "pneumaticcraft.gui.progWidget.area.type.sphere.sphereType." + name;
        }

        @Override
        public String getTranslationKey() {
            return this.name;
        }
    }
}

