/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.heat;

import java.util.Arrays;
import java.util.HashSet;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;

public class TemperatureData
implements INBTSerializable<CompoundTag> {
    private final Double[] temp = new Double[7];
    private boolean isMultisided;

    public static TemperatureData fromNBT(CompoundTag nbt) {
        TemperatureData data = new TemperatureData();
        data.deserializeNBT(nbt);
        return data;
    }

    private TemperatureData() {
        this.isMultisided = false;
    }

    public TemperatureData(ICapabilityProvider provider) {
        Arrays.fill((Object[])this.temp, null);
        HashSet heatExchangers = new HashSet();
        for (Direction face : DirectionUtil.VALUES) {
            provider.getCapability(PNCCapabilities.HEAT_EXCHANGER_CAPABILITY, face).ifPresent(heatExchangers::add);
        }
        if (heatExchangers.size() > 1) {
            this.isMultisided = true;
            for (Direction face : DirectionUtil.VALUES) {
                provider.getCapability(PNCCapabilities.HEAT_EXCHANGER_CAPABILITY, face).ifPresent(h -> {
                    this.temp[face.m_122411_()] = h.getTemperature();
                });
            }
        } else if (heatExchangers.size() == 1) {
            this.isMultisided = false;
            provider.getCapability(PNCCapabilities.HEAT_EXCHANGER_CAPABILITY).ifPresent(h -> {
                this.temp[6] = h.getTemperature();
            });
        } else {
            this.isMultisided = false;
        }
    }

    public boolean isMultisided() {
        return this.isMultisided;
    }

    public double getTemperature(Direction face) {
        return face == null ? this.temp[6] : this.temp[face.m_122411_()];
    }

    public boolean hasData(Direction face) {
        return face == null ? this.temp[6] != null : this.temp[face.m_122411_()] != null;
    }

    public CompoundTag toNBT() {
        CompoundTag nbt = new CompoundTag();
        if (this.isMultisided()) {
            ListTag tagList = new ListTag();
            for (Direction face : DirectionUtil.VALUES) {
                if (this.temp[face.m_122411_()] == null) continue;
                CompoundTag heatTag = new CompoundTag();
                heatTag.m_128344_("side", (byte)face.m_122411_());
                heatTag.m_128405_("temp", (int)this.getTemperature(face));
                tagList.add((Object)heatTag);
            }
            nbt.m_128365_("heat", (Tag)tagList);
        } else {
            nbt.m_128405_("temp", (int)this.getTemperature(null));
        }
        return nbt;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        if (this.isMultisided()) {
            ListTag tagList = new ListTag();
            for (Direction face : DirectionUtil.VALUES) {
                CompoundTag heatTag = new CompoundTag();
                heatTag.m_128344_("side", (byte)face.m_122411_());
                heatTag.m_128405_("temp", (int)this.getTemperature(face));
                tagList.add((Object)heatTag);
            }
            nbt.m_128365_("heat", (Tag)tagList);
        } else {
            nbt.m_128405_("temp", (int)this.getTemperature(null));
        }
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt.m_128441_("heat")) {
            this.isMultisided = true;
            ListTag tagList = nbt.m_128437_("heat", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundTag heatTag = tagList.m_128728_(i);
                this.temp[heatTag.m_128445_((String)"side")] = heatTag.m_128451_("temp");
            }
        } else {
            this.isMultisided = false;
            this.temp[6] = nbt.m_128451_("temp");
        }
    }
}

