/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.item.IPositionProvider;
import me.desht.pneumaticcraft.client.gui.GPSToolScreen;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.item.IGPSToolSync;
import me.desht.pneumaticcraft.common.util.NBTUtils;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.variables.GlobalVariableHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class GPSToolItem
extends Item
implements IPositionProvider,
IGPSToolSync {
    public GPSToolItem() {
        super(ModItems.defaultProps());
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        BlockPos pos = ctx.m_8083_();
        if (ctx.m_43723_() == null) {
            return InteractionResult.PASS;
        }
        GPSToolItem.setGPSLocation(ctx.m_43723_().m_20148_(), ctx.m_43723_().m_21120_(ctx.m_43724_()), pos);
        if (!ctx.m_43725_().f_46443_) {
            ctx.m_43723_().m_5661_((Component)Component.m_237110_((String)"pneumaticcraft.message.gps_tool.targetSet", (Object[])new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}).m_130940_(ChatFormatting.GREEN), false);
        }
        ctx.m_43723_().m_5496_((SoundEvent)ModSounds.CHIRP.get(), 1.0f, 1.5f);
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        if (worldIn.f_46443_) {
            GPSToolScreen.showGUI(stack, handIn, GPSToolItem.getGPSLocation(playerIn.m_20148_(), stack).orElse(playerIn.m_20183_()));
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> infoList, TooltipFlag par4) {
        super.m_7373_(stack, worldIn, infoList, par4);
        if (worldIn != null) {
            ClientUtils.addGuiContextSensitiveTooltip(stack, infoList);
            GPSToolItem.getGPSLocation(ClientUtils.getClientPlayer().m_20148_(), stack).ifPresent(pos -> {
                MutableComponent translated = Component.m_237115_((String)worldIn.m_8055_(pos).m_60734_().m_7705_());
                MutableComponent blockName = worldIn.m_46749_(pos) ? Component.m_237113_((String)" (").m_7220_((Component)translated).m_130946_(")") : Component.m_237119_().m_6879_();
                String str = String.format("[%d, %d, %d]", pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
                infoList.add((Component)Component.m_237113_((String)str).m_130940_(ChatFormatting.YELLOW).m_7220_((Component)blockName.m_130940_(ChatFormatting.GREEN)));
            });
            String varName = GPSToolItem.getVariable(stack);
            if (!varName.isEmpty()) {
                infoList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.gpsTool.variable", varName));
            }
        }
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean heldItem) {
        String var = GPSToolItem.getVariable(stack);
        if (!var.isEmpty() && !world.f_46443_ && entity instanceof Player) {
            GPSToolItem.getGPSLocation(entity.m_20148_(), stack).ifPresent(curPos -> {
                BlockPos varPos = GlobalVariableHelper.getPos(entity.m_20148_(), var, PneumaticCraftUtils.invalidPos());
                if (!varPos.equals(curPos)) {
                    GPSToolItem.setGPSLocation(entity.m_20148_(), stack, varPos, false);
                }
            });
        }
    }

    @Nonnull
    public static Optional<BlockPos> getGPSLocation(ItemStack stack) {
        return GPSToolItem.getGPSLocation(null, stack);
    }

    @Nonnull
    public static Optional<BlockPos> getGPSLocation(UUID playerId, ItemStack gpsTool) {
        CompoundTag compound = gpsTool.m_41783_();
        if (gpsTool.m_41720_() == ModItems.GPS_TOOL.get() && compound != null) {
            BlockPos pos;
            BlockPos curPos = compound.m_128441_("Pos") ? NbtUtils.m_129239_((CompoundTag)compound.m_128469_("Pos")) : PneumaticCraftUtils.invalidPos();
            String var = GPSToolItem.getVariable(gpsTool);
            if (!var.isEmpty() && (pos = GlobalVariableHelper.getPos(playerId, var)) != null && !curPos.equals((Object)pos)) {
                GPSToolItem.setGPSLocation(playerId, gpsTool, pos, false);
            }
            return PneumaticCraftUtils.isValidPos(curPos) ? Optional.of(curPos) : Optional.empty();
        }
        return Optional.empty();
    }

    public static void setGPSLocation(UUID playerId, ItemStack gpsTool, BlockPos pos) {
        GPSToolItem.setGPSLocation(playerId, gpsTool, pos, true);
    }

    public static void setGPSLocation(UUID playerId, ItemStack gpsTool, BlockPos pos, boolean updateVarManager) {
        String var;
        NBTUtils.setCompoundTag(gpsTool, "Pos", (Tag)NbtUtils.m_129224_((BlockPos)pos));
        if (updateVarManager && !(var = GPSToolItem.getVariable(gpsTool)).isEmpty()) {
            GlobalVariableHelper.setPos(playerId, var, pos);
        }
    }

    public static void setVariable(ItemStack gpsTool, String variable) {
        NBTUtils.setString(gpsTool, "variable", variable);
    }

    public static String getVariable(ItemStack gpsTool) {
        return gpsTool.m_41782_() ? Objects.requireNonNull(gpsTool.m_41783_()).m_128461_("variable") : "";
    }

    @Override
    public List<BlockPos> getStoredPositions(UUID playerId, @Nonnull ItemStack stack) {
        return GPSToolItem.getGPSLocation(playerId, stack).map(Collections::singletonList).orElse(Collections.emptyList());
    }

    @Override
    public int getRenderColor(int index) {
        return -1862271232;
    }

    @Override
    public void syncVariables(ServerPlayer player, ItemStack stack) {
        String varName = GPSToolItem.getVariable(stack);
        if (GlobalVariableHelper.hasPrefix(varName)) {
            PneumaticRegistry.getInstance().getMiscHelpers().syncGlobalVariable(player, varName);
        }
    }

    @Override
    public void syncFromClient(Player player, ItemStack stack, int index, BlockPos pos, String varName) {
        GPSToolItem.setVariable(stack, varName);
        GPSToolItem.setGPSLocation(player.m_20148_(), stack, pos);
        if (!varName.isEmpty()) {
            GlobalVariableHelper.setPos(player.m_20148_(), varName, pos);
        }
    }
}

