/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import java.util.Objects;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.common.block.entity.AbstractPneumaticCraftBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.block.entity.ISerializableTanks;
import me.desht.pneumaticcraft.common.block.entity.ISideConfigurable;
import me.desht.pneumaticcraft.common.block.entity.SideConfigurator;
import me.desht.pneumaticcraft.common.core.ModLootFunctions;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.NBTUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class LootFunc {

    public static class BlockEntitySerializerFunction
    extends LootItemConditionalFunction {
        private BlockEntitySerializerFunction(LootItemCondition[] conditionsIn) {
            super(conditionsIn);
        }

        protected ItemStack m_7372_(ItemStack stack, LootContext context) {
            return this.applyBEdata(stack, (BlockEntity)context.m_78953_(LootContextParams.f_81462_));
        }

        public static LootItemConditionalFunction.Builder<?> builder() {
            return BlockEntitySerializerFunction.m_80683_(BlockEntitySerializerFunction::new);
        }

        private ItemStack applyBEdata(ItemStack teStack, BlockEntity te) {
            ISideConfigurable sc;
            CompoundTag tag;
            ISerializableTanks s;
            CompoundTag tankTag;
            CompoundTag subTag;
            CompoundTag nbt = teStack.m_41737_("BlockEntityTag");
            CompoundTag compoundTag = subTag = nbt == null ? new CompoundTag() : nbt;
            if (te instanceof ISerializableTanks && !(tankTag = (s = (ISerializableTanks)te).serializeTanks()).m_128456_()) {
                subTag.m_128365_("SavedTanks", (Tag)tankTag);
            }
            if (te instanceof ISideConfigurable && !(tag = SideConfigurator.writeToNBT(sc = (ISideConfigurable)te)).m_128456_()) {
                subTag.m_128365_("SideConfiguration", (Tag)tag);
            }
            if (te instanceof IRedstoneControl) {
                IRedstoneControl rc = (IRedstoneControl)te;
                rc.getRedstoneController().serialize(subTag);
            }
            if (te instanceof AbstractPneumaticCraftBlockEntity) {
                AbstractPneumaticCraftBlockEntity teB = (AbstractPneumaticCraftBlockEntity)te;
                if (teB.shouldPreserveStateOnBreak()) {
                    AbstractPneumaticCraftBlockEntity.UpgradeHandler upgradeHandler = teB.getUpgradeHandler();
                    for (int i = 0; i < upgradeHandler.getSlots(); ++i) {
                        if (upgradeHandler.getStackInSlot(i).m_41619_()) continue;
                        if (teB.getUpgrades(ModUpgrades.CREATIVE.get()) > 0) {
                            NBTUtils.setBoolean(teStack, "CreativeUpgrade", true);
                        } else {
                            NBTUtils.removeTag(teStack, "CreativeUpgrade");
                        }
                        subTag.m_128365_("UpgradeInventory", (Tag)upgradeHandler.serializeNBT());
                        break;
                    }
                    te.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY).ifPresent(h -> {
                        if (h.getPressure() != 0.0f) {
                            subTag.m_128405_("AirAmount", h.getAir());
                        }
                    });
                }
                teB.serializeExtraItemData(subTag, teB.shouldPreserveStateOnBreak());
            }
            if (!subTag.m_128456_()) {
                CompoundTag tag2 = teStack.m_41784_();
                tag2.m_128365_("BlockEntityTag", (Tag)subTag);
            } else if (teStack.m_41782_() && Objects.requireNonNull(teStack.m_41783_()).m_128441_("BlockEntityTag")) {
                teStack.m_41783_().m_128473_("BlockEntityTag");
            }
            return teStack;
        }

        public LootItemFunctionType m_7162_() {
            return (LootItemFunctionType)ModLootFunctions.TE_SERIALIZER.get();
        }

        public static class Serializer
        extends LootItemConditionalFunction.Serializer<BlockEntitySerializerFunction> {
            public BlockEntitySerializerFunction deserialize(JsonObject object, JsonDeserializationContext deserializationContext, LootItemCondition[] conditionsIn) {
                return new BlockEntitySerializerFunction(conditionsIn);
            }
        }
    }
}

