/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.block.AphorismTileBlock;
import me.desht.pneumaticcraft.common.block.entity.AphorismTileBlockEntity;
import me.desht.pneumaticcraft.common.network.LocationIntPacket;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class PacketAphorismTileUpdate
extends LocationIntPacket {
    private static final int MAX_LENGTH = 1024;
    private final String[] text;
    private final int textRotation;
    private final byte margin;
    private final boolean invis;
    private final int playerId;

    public PacketAphorismTileUpdate(FriendlyByteBuf buffer) {
        super(buffer);
        this.textRotation = buffer.readByte();
        int lines = buffer.m_130242_();
        this.text = new String[lines];
        for (int i = 0; i < lines; ++i) {
            this.text[i] = buffer.m_130136_(1024);
        }
        this.margin = buffer.readByte();
        this.invis = buffer.readBoolean();
        this.playerId = buffer.readInt();
    }

    public PacketAphorismTileUpdate(AphorismTileBlockEntity tile) {
        this(tile, null);
    }

    public PacketAphorismTileUpdate(AphorismTileBlockEntity tile, Player player) {
        super(tile.m_58899_());
        this.text = tile.getTextLines();
        this.textRotation = tile.textRotation;
        this.margin = tile.getMarginSize();
        this.invis = (Boolean)tile.m_58900_().m_61143_((Property)AphorismTileBlock.INVISIBLE);
        this.playerId = player == null ? 0 : player.m_19879_();
    }

    @Override
    public void toBytes(FriendlyByteBuf buffer) {
        super.toBytes(buffer);
        buffer.writeByte(this.textRotation);
        buffer.m_130130_(this.text.length);
        Arrays.stream(this.text).forEach(s -> buffer.m_130072_(s, 1024));
        buffer.writeByte((int)this.margin);
        buffer.writeBoolean(this.invis);
        buffer.writeInt(this.playerId);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                Player player = ClientUtils.getClientPlayer();
                if (this.playerId != player.m_19879_()) {
                    this.updateAphorismTile(player);
                }
            } else {
                AphorismTileBlockEntity tile;
                Player player = (Player)Objects.requireNonNull(((NetworkEvent.Context)ctx.get()).getSender());
                if (PneumaticCraftUtils.canPlayerReach(player, this.pos) && (tile = this.updateAphorismTile(player)) != null) {
                    NetworkHandler.sendToAllTracking(new PacketAphorismTileUpdate(tile, player), player.m_9236_(), this.pos);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private AphorismTileBlockEntity updateAphorismTile(Player player) {
        return PneumaticCraftUtils.getTileEntityAt((BlockGetter)player.m_9236_(), this.pos, AphorismTileBlockEntity.class).map(te -> {
            te.setTextLines(this.text, false);
            te.textRotation = this.textRotation;
            te.setMarginSize(this.margin);
            te.setInvisible(this.invis);
            return te;
        }).orElse(null);
    }
}

