/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.network.PacketMultiHeader;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class PacketMultiPart {
    private final byte[] payload;

    PacketMultiPart(byte[] payload) {
        this.payload = payload;
    }

    PacketMultiPart(FriendlyByteBuf buf) {
        this.payload = new byte[buf.readInt()];
        buf.readBytes(this.payload);
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.payload.length);
        buf.writeBytes(this.payload);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> PacketMultiHeader.receivePayload((Player)((NetworkEvent.Context)ctx.get()).getSender(), this.payload));
        ctx.get().setPacketHandled(true);
    }
}

