/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.immersiveengineering;

import blusunrize.immersiveengineering.api.Lib;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import me.desht.pneumaticcraft.common.particle.AirParticleData;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ElectricAttackHandler {
    private static final Map<UUID, Long> sounds = new HashMap<UUID, Long>();

    @SubscribeEvent
    public static void onElectricalAttack(LivingHurtEvent event) {
        if (!event.getSource().m_276093_(Lib.DamageTypes.WIRE_SHOCK)) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof DroneEntity) {
            DroneEntity drone = (DroneEntity)livingEntity;
            if (drone.getUpgrades(ModUpgrades.SECURITY.get()) > 0) {
                float dmg = event.getAmount();
                ((IAirHandler)drone.getCapability(PNCCapabilities.AIR_HANDLER_CAPABILITY).orElseThrow(RuntimeException::new)).addAir((int)(-50.0f * dmg));
                double dy = Math.min((double)(dmg / 4.0f), 0.5);
                NetworkHandler.sendToAllTracking((Object)new PacketSpawnParticle(AirParticleData.DENSE, drone.m_20185_(), drone.m_20186_(), drone.m_20189_(), 0.0, -dy, 0.0, (int)dmg, 0.0, 0.0, 0.0), (Entity)drone);
                event.setAmount(0.0f);
                ElectricAttackHandler.playLeakSound((Entity)drone);
            }
        } else {
            Player player;
            CommonArmorHandler handler;
            LivingEntity dmg = event.getEntity();
            if (dmg instanceof Player && (handler = CommonArmorHandler.getHandlerForPlayer(player = (Player)dmg)).getUpgradeCount(EquipmentSlot.CHEST, ModUpgrades.SECURITY.get()) > 0 && (double)handler.getArmorPressure(EquipmentSlot.CHEST) > 0.1 && handler.isArmorReady(EquipmentSlot.CHEST)) {
                handler.addAir(EquipmentSlot.CHEST, (int)(-150.0f * event.getAmount()));
                float sx = player.m_217043_().m_188501_() * 1.5f - 0.75f;
                float sz = player.m_217043_().m_188501_() * 1.5f - 0.75f;
                double dy = Math.min((double)(event.getAmount() / 4.0f), 0.5);
                NetworkHandler.sendToAllTracking(new PacketSpawnParticle(AirParticleData.DENSE, player.m_20185_() + (double)sx, player.m_20186_() + 1.0, player.m_20189_() + (double)sz, sx / 4.0f, -dy, sz / 4.0f), player.m_9236_(), player.m_20183_());
                event.setAmount(0.0f);
                ElectricAttackHandler.playLeakSound((Entity)player);
            }
        }
    }

    private static void playLeakSound(Entity e) {
        if (e.m_9236_().m_46467_() - sounds.getOrDefault(e.m_20148_(), 0L) > 16L) {
            e.m_9236_().m_5594_(null, e.m_20183_(), (SoundEvent)ModSounds.LEAKING_GAS.get(), SoundSource.PLAYERS, 0.5f, 0.7f);
            sounds.put(e.m_20148_(), e.m_9236_().m_46467_());
        }
    }
}

