/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.mekanism;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerAdapter;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.heat.HeatExchangerLogicAmbient;
import me.desht.pneumaticcraft.common.thirdparty.mekanism.MekanismIntegration;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import mekanism.api.heat.IHeatHandler;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ForgeRegistries;

public class Mek2PNCHeatProvider
implements ICapabilityProvider {
    private final List<LazyOptional<IHeatExchangerLogic>> handlers = new ArrayList<LazyOptional<IHeatExchangerLogic>>();
    private final WeakReference<BlockEntity> teRef;

    public Mek2PNCHeatProvider(BlockEntity te) {
        this.teRef = new WeakReference<BlockEntity>(te);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        LazyOptional heatHandler;
        int idx;
        BlockEntity blockEntity = (BlockEntity)this.teRef.get();
        if (cap != PNCCapabilities.HEAT_EXCHANGER_CAPABILITY || blockEntity == null || !blockEntity.getCapability(MekanismIntegration.CAPABILITY_HEAT_HANDLER, side).isPresent()) {
            return LazyOptional.empty();
        }
        if (this.handlers.isEmpty()) {
            for (int i = 0; i < 7; ++i) {
                this.handlers.add((LazyOptional<IHeatExchangerLogic>)LazyOptional.empty());
            }
        }
        int n = idx = side == null ? 6 : side.m_122411_();
        if (!this.handlers.get(idx).isPresent() && (heatHandler = blockEntity.getCapability(MekanismIntegration.CAPABILITY_HEAT_HANDLER, side)).isPresent()) {
            heatHandler.addListener(l -> this.handlers.set(idx, (LazyOptional<IHeatExchangerLogic>)LazyOptional.empty()));
            Mek2PNCHeatAdapter adapter = new Mek2PNCHeatAdapter(side, (LazyOptional<IHeatHandler>)heatHandler, HeatExchangerLogicAmbient.atPosition((LevelAccessor)blockEntity.m_58904_(), blockEntity.m_58899_()).getAmbientTemperature(), this.getResistanceMultiplier(blockEntity));
            this.handlers.set(idx, (LazyOptional<IHeatExchangerLogic>)LazyOptional.of(() -> adapter));
        }
        return this.handlers.get(idx);
    }

    private double getResistanceMultiplier(BlockEntity te) {
        return PneumaticCraftUtils.getRegistryName(ForgeRegistries.BLOCK_ENTITY_TYPES, te.m_58903_()).map(name -> {
            if (name.m_135827_().equals("mekanism") && (name.m_135815_().equals("quantum_entangloporter") || name.m_135815_().endsWith("thermodynamic_conductor"))) {
                return 10000000;
            }
            return 1;
        }).orElse(1).intValue();
    }

    public static class Mek2PNCHeatAdapter
    extends IHeatExchangerAdapter.Simple<IHeatHandler> {
        private final double thermalResistanceMult;

        public Mek2PNCHeatAdapter(Direction side, LazyOptional<IHeatHandler> heatHandler, double ambientTemperature, double thermalResistanceMult) {
            super(side, heatHandler, ambientTemperature);
            this.thermalResistanceMult = thermalResistanceMult;
        }

        @Override
        public double getTemperature() {
            return this.foreignHeatCap.map(h -> h.getTemperature(0)).orElse(0.0);
        }

        @Override
        public double getThermalResistance() {
            return this.foreignHeatCap.map(h -> h.getInverseConduction(0) * this.thermalResistanceMult).orElse(1.0);
        }

        @Override
        public double getThermalCapacity() {
            return this.foreignHeatCap.map(h -> h.getHeatCapacity(0)).orElse(0.0);
        }

        @Override
        public void addHeat(double amount) {
            if (amount > 0.0) {
                this.foreignHeatCap.ifPresent(h -> h.handleHeat(amount / (Double)ConfigHelper.common().integration.mekThermalEfficiencyFactor.get()));
            }
        }
    }
}

