/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tubemodules;

import java.util.List;
import java.util.Objects;
import me.desht.pneumaticcraft.client.gui.tubemodule.AbstractTubeModuleScreen;
import me.desht.pneumaticcraft.common.block.PressureTubeBlock;
import me.desht.pneumaticcraft.common.block.entity.PressureTubeBlockEntity;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.tubemodules.INetworkedModule;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class AbstractTubeModule {
    public static final float MAX_VALUE = 30.0f;
    protected final PressureTubeBlockEntity pressureTube;
    private final VoxelShape[] boundingBoxes;
    protected final Direction dir;
    private boolean fake;
    private boolean shouldDrop;
    protected boolean upgraded;
    public float lowerBound = 4.9f;
    public float higherBound = 0.0f;
    public boolean advancedConfig;
    private ResourceLocation regName;

    public AbstractTubeModule(Direction dir, PressureTubeBlockEntity pressureTube) {
        this.dir = dir;
        this.pressureTube = pressureTube;
        double w = this.getWidth() / 2.0;
        double h = this.getHeight();
        this.boundingBoxes = new VoxelShape[]{Block.m_49796_((double)(8.0 - w), (double)(6.0 - h), (double)(8.0 - w), (double)(8.0 + w), (double)6.0, (double)(8.0 + w)), Block.m_49796_((double)(8.0 - w), (double)10.0, (double)(8.0 - w), (double)(8.0 + w), (double)(10.0 + h), (double)(8.0 + w)), Block.m_49796_((double)(8.0 - w), (double)(8.0 - w), (double)(6.0 - h), (double)(8.0 + w), (double)(8.0 + w), (double)6.0), Block.m_49796_((double)(8.0 - w), (double)(8.0 - w), (double)10.0, (double)(8.0 + w), (double)(8.0 + w), (double)(10.0 + h)), Block.m_49796_((double)(6.0 - h), (double)(8.0 - w), (double)(8.0 - w), (double)6.0, (double)(8.0 + w), (double)(8.0 + w)), Block.m_49796_((double)10.0, (double)(8.0 - w), (double)(8.0 - w), (double)(10.0 + h), (double)(8.0 + w), (double)(8.0 + w))};
    }

    public void markFake() {
        this.fake = true;
    }

    public boolean isFake() {
        return this.fake;
    }

    public PressureTubeBlockEntity getTube() {
        return this.pressureTube;
    }

    public boolean isValid() {
        return !this.pressureTube.m_58901_();
    }

    protected final void setChanged() {
        if (this.pressureTube != null && this.pressureTube.m_58904_() != null && !this.pressureTube.m_58904_().f_46443_) {
            this.pressureTube.m_6596_();
        }
    }

    public double getWidth() {
        return 4.0;
    }

    protected double getHeight() {
        return 6.0;
    }

    public float getThreshold(int redstone) {
        double slope = (this.higherBound - this.lowerBound) / 15.0f;
        double threshold = (double)this.lowerBound + slope * (double)redstone;
        return (float)threshold;
    }

    public NonNullList<ItemStack> getDrops() {
        NonNullList drops = NonNullList.m_122779_();
        if (this.shouldDrop) {
            drops.add((Object)new ItemStack((ItemLike)this.getItem()));
            if (this.upgraded) {
                drops.add((Object)new ItemStack((ItemLike)ModItems.MODULE_EXPANSION_CARD.get()));
            }
        }
        return drops;
    }

    public abstract Item getItem();

    public Direction getDirection() {
        return this.dir;
    }

    public void readFromNBT(CompoundTag nbt) {
        this.lowerBound = nbt.m_128457_("lowerBound");
        this.higherBound = nbt.m_128457_("higherBound");
        this.upgraded = nbt.m_128471_("upgraded");
        this.advancedConfig = nbt.m_128471_("advancedConfig");
    }

    public CompoundTag writeToNBT(CompoundTag nbt) {
        nbt.m_128405_("dir", this.dir.m_122411_());
        nbt.m_128350_("lowerBound", this.lowerBound);
        nbt.m_128350_("higherBound", this.higherBound);
        if (this.upgraded) {
            nbt.m_128379_("upgraded", true);
        }
        if (this.advancedConfig) {
            nbt.m_128379_("advancedConfig", true);
        }
        return nbt;
    }

    protected void tickCommon() {
    }

    public void tickClient() {
        this.tickCommon();
    }

    public void tickServer() {
        this.shouldDrop = true;
        this.tickCommon();
    }

    public void onNeighborTileUpdate() {
    }

    public void onNeighborBlockUpdate() {
    }

    public final ResourceLocation getType() {
        if (this.regName == null) {
            this.regName = PneumaticCraftUtils.getRegistryName(this.getItem()).orElseThrow();
        }
        return this.regName;
    }

    public int getRedstoneLevel() {
        return 0;
    }

    public void updateNeighbors() {
        Level level = this.pressureTube.nonNullLevel();
        BlockPos pos = this.pressureTube.m_58899_();
        level.m_46672_(pos, level.m_8055_(pos).m_60734_());
    }

    public boolean isInline() {
        return false;
    }

    public void sendDescriptionPacket() {
        this.pressureTube.sendDescriptionPacket();
    }

    public void addInfo(List<Component> curInfo) {
        if (this.upgraded) {
            ItemStack stack = new ItemStack((ItemLike)ModItems.MODULE_EXPANSION_CARD.get());
            curInfo.add((Component)stack.m_41786_().m_6881_().m_130946_(" installed").m_130940_(ChatFormatting.GREEN));
        }
        if (this instanceof INetworkedModule) {
            int colorChannel = ((INetworkedModule)((Object)this)).getColorChannel();
            String key = "color.minecraft." + String.valueOf(DyeColor.m_41053_((int)colorChannel));
            curInfo.add((Component)Component.m_237115_((String)"pneumaticcraft.waila.logisticsModule.channel").m_130946_(" ").m_7220_((Component)Component.m_237115_((String)key).m_130940_(ChatFormatting.YELLOW)));
        }
    }

    public boolean canUpgrade() {
        return true;
    }

    public void upgrade() {
        if (!this.upgraded) {
            this.setChanged();
            this.upgraded = true;
        }
    }

    public boolean isUpgraded() {
        return this.upgraded;
    }

    public boolean onActivated(Player player, InteractionHand hand) {
        if (player.m_9236_().f_46443_ && this.hasGui()) {
            AbstractTubeModuleScreen.openGuiForModule(this);
        }
        return true;
    }

    public boolean hasGui() {
        return false;
    }

    public VoxelShape getShape() {
        return this.boundingBoxes[this.getDirection().m_122411_()];
    }

    public AABB getRenderBoundingBox() {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractTubeModule)) {
            return false;
        }
        AbstractTubeModule that = (AbstractTubeModule)o;
        return Objects.equals(this.pressureTube.m_58899_(), that.pressureTube.m_58899_()) && this.dir == that.dir;
    }

    public int hashCode() {
        return Objects.hash(this.pressureTube.m_58899_(), this.dir);
    }

    public void onPlaced() {
    }

    public void onRemoved() {
    }

    public boolean isInlineAndFocused(PressureTubeBlock.TubeHitInfo hitInfo) {
        return false;
    }

    public boolean canConnectTo(AbstractTubeModule other) {
        return this.getClass() == other.getClass();
    }
}

